/*
 * Decompiled with CFR 0.152.
 */
package davmail;

import davmail.AbstractConnection;
import davmail.BundleMessage;
import davmail.Settings;
import davmail.exception.DavMailException;
import davmail.ui.tray.DavGatewayTray;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.HashSet;
import javax.net.ServerSocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;

public abstract class AbstractServer
extends Thread {
    protected boolean nosslFlag;
    private final int port;
    private ServerSocket serverSocket;

    public abstract String getProtocolName();

    public int getPort() {
        return this.port;
    }

    public AbstractServer(String name, int port, int defaultPort) {
        super(name);
        this.setDaemon(true);
        this.port = port == 0 ? defaultPort : port;
    }

    public void bind() throws DavMailException {
        ServerSocketFactory serverSocketFactory;
        String bindAddress = Settings.getProperty("davmail.bindAddress");
        String keystoreFile = Settings.getProperty("davmail.ssl.keystoreFile");
        if (keystoreFile == null || keystoreFile.length() == 0 || this.nosslFlag) {
            serverSocketFactory = ServerSocketFactory.getDefault();
        } else {
            FileInputStream keyStoreInputStream = null;
            try {
                keyStoreInputStream = new FileInputStream(keystoreFile);
                KeyStore keystore = KeyStore.getInstance(Settings.getProperty("davmail.ssl.keystoreType"));
                keystore.load(keyStoreInputStream, Settings.getCharArrayProperty("davmail.ssl.keystorePass"));
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmf.init(keystore, Settings.getCharArrayProperty("davmail.ssl.keyPass"));
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(kmf.getKeyManagers(), null, null);
                serverSocketFactory = sslContext.getServerSocketFactory();
            }
            catch (IOException ex) {
                throw new DavMailException("LOG_EXCEPTION_CREATING_SSL_SERVER_SOCKET", this.getProtocolName(), this.port, ex.getMessage() == null ? ex.toString() : ex.getMessage());
            }
            catch (GeneralSecurityException ex) {
                throw new DavMailException("LOG_EXCEPTION_CREATING_SSL_SERVER_SOCKET", this.getProtocolName(), this.port, ex.getMessage() == null ? ex.toString() : ex.getMessage());
            }
            finally {
                if (keyStoreInputStream != null) {
                    try {
                        keyStoreInputStream.close();
                    }
                    catch (IOException exc) {
                        DavGatewayTray.warn(new BundleMessage("LOG_EXCEPTION_CLOSING_KEYSTORE_INPUT_STREAM", new Object[0]), exc);
                    }
                }
            }
        }
        try {
            this.serverSocket = bindAddress == null || bindAddress.length() == 0 ? serverSocketFactory.createServerSocket(this.port) : serverSocketFactory.createServerSocket(this.port, 0, Inet4Address.getByName(bindAddress));
            if (this.serverSocket instanceof SSLServerSocket) {
                HashSet<String> protocols = new HashSet<String>();
                for (String protocol : ((SSLServerSocket)this.serverSocket).getEnabledProtocols()) {
                    if (protocol.startsWith("SSL")) continue;
                    protocols.add(protocol);
                }
                ((SSLServerSocket)this.serverSocket).setEnabledProtocols(protocols.toArray(new String[protocols.size()]));
            }
        }
        catch (IOException e) {
            throw new DavMailException("LOG_SOCKET_BIND_FAILED", this.getProtocolName(), this.port);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Socket clientSocket = null;
        AbstractConnection connection = null;
        try {
            try {
                while (true) {
                    clientSocket = this.serverSocket.accept();
                    clientSocket.setSoTimeout(Settings.getIntProperty("davmail.clientSoTimeout", 300) * 1000);
                    DavGatewayTray.debug(new BundleMessage("LOG_CONNECTION_FROM", clientSocket.getInetAddress(), this.port));
                    if (Settings.getBooleanProperty("davmail.allowRemote") || clientSocket.getInetAddress().isLoopbackAddress()) {
                        connection = this.createConnectionHandler(clientSocket);
                        connection.start();
                        continue;
                    }
                    clientSocket.close();
                    DavGatewayTray.warn(new BundleMessage("LOG_EXTERNAL_CONNECTION_REFUSED", new Object[0]));
                }
            }
            catch (IOException e) {
                if (!this.serverSocket.isClosed()) {
                    DavGatewayTray.warn(new BundleMessage("LOG_EXCEPTION_LISTENING_FOR_CONNECTIONS", new Object[0]), e);
                }
                try {
                    if (clientSocket != null) {
                        clientSocket.close();
                    }
                }
                catch (IOException e2) {
                    DavGatewayTray.warn(new BundleMessage("LOG_EXCEPTION_CLOSING_CLIENT_SOCKET", new Object[0]), e2);
                }
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (Throwable throwable) {
            try {
                if (clientSocket != null) {
                    clientSocket.close();
                }
            }
            catch (IOException e) {
                DavGatewayTray.warn(new BundleMessage("LOG_EXCEPTION_CLOSING_CLIENT_SOCKET", new Object[0]), e);
            }
            if (connection != null) {
                connection.close();
            }
            throw throwable;
        }
    }

    public abstract AbstractConnection createConnectionHandler(Socket var1);

    public void close() {
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (IOException e) {
            DavGatewayTray.warn(new BundleMessage("LOG_EXCEPTION_CLOSING_SERVER_SOCKET", new Object[0]), e);
        }
    }
}

