/*
 * Decompiled with CFR 0.152.
 */
package davmail.caldav;

import davmail.AbstractConnection;
import davmail.BundleMessage;
import davmail.DavGateway;
import davmail.Settings;
import davmail.exception.DavMailAuthenticationException;
import davmail.exception.DavMailException;
import davmail.exception.HttpNotFoundException;
import davmail.exception.HttpPreconditionFailedException;
import davmail.exception.HttpServerErrorException;
import davmail.exchange.ExchangeSession;
import davmail.exchange.ExchangeSessionFactory;
import davmail.exchange.ICSBufferedReader;
import davmail.exchange.XMLStreamUtil;
import davmail.ui.tray.DavGatewayTray;
import davmail.util.IOUtil;
import davmail.util.StringUtil;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.Writer;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CaldavConnection
extends AbstractConnection {
    protected static final int MAX_KEEP_ALIVE_TIME = 300;
    protected final Logger wireLogger = Logger.getLogger(this.getClass());
    protected boolean closed;
    public static final BitSet ical_allowed_abs_path = new BitSet(256);

    static String encodePath(CaldavRequest request, String path) throws URIException {
        if (request.isIcal5()) {
            return URIUtil.encode((String)path, (BitSet)ical_allowed_abs_path, (String)"UTF-8");
        }
        return URIUtil.encodePath((String)path, (String)"UTF-8");
    }

    public CaldavConnection(Socket clientSocket) {
        super(CaldavConnection.class.getSimpleName(), clientSocket, "UTF-8");
        this.wireLogger.setLevel(Settings.getLoggingLevel("davmail"));
    }

    protected Map<String, String> parseHeaders() throws IOException {
        String line;
        HashMap<String, String> headers = new HashMap<String, String>();
        while ((line = this.readClient()) != null && line.length() > 0) {
            int index = line.indexOf(58);
            if (index <= 0) {
                this.wireLogger.warn((Object)("Invalid header: " + line));
                throw new DavMailException("EXCEPTION_INVALID_HEADER", new Object[0]);
            }
            headers.put(line.substring(0, index).toLowerCase(), line.substring(index + 1).trim());
        }
        return headers;
    }

    protected String getContent(String contentLength) throws IOException {
        int size;
        if (contentLength == null || contentLength.length() == 0) {
            return null;
        }
        try {
            size = Integer.parseInt(contentLength);
        }
        catch (NumberFormatException e) {
            throw new DavMailException("EXCEPTION_INVALID_CONTENT_LENGTH", contentLength);
        }
        String content = this.in.readContentAsString(size);
        if (this.wireLogger.isDebugEnabled()) {
            this.wireLogger.debug((Object)("< " + content));
        }
        return content;
    }

    protected void setSocketTimeout(String keepAliveValue) throws IOException {
        if (keepAliveValue != null && keepAliveValue.length() > 0) {
            int keepAlive;
            try {
                keepAlive = Integer.parseInt(keepAliveValue);
            }
            catch (NumberFormatException e) {
                throw new DavMailException("EXCEPTION_INVALID_KEEPALIVE", keepAliveValue);
            }
            if (keepAlive > 300) {
                keepAlive = 300;
            }
            this.client.setSoTimeout(keepAlive * 1000);
            DavGatewayTray.debug(new BundleMessage("LOG_SET_SOCKET_TIMEOUT", keepAlive));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (!this.closed) {
                String line = this.readClient();
                if (line == null) {
                    break;
                }
                StringTokenizer tokens = new StringTokenizer(line);
                String command = tokens.nextToken();
                Map<String, String> headers = this.parseHeaders();
                String encodedPath = StringUtil.encodePlusSign(tokens.nextToken());
                String path = URIUtil.decode((String)encodedPath);
                String content = this.getContent(headers.get("content-length"));
                this.setSocketTimeout(headers.get("keep-alive"));
                this.closed = "close".equals(headers.get("connection"));
                if ("OPTIONS".equals(command)) {
                    this.sendOptions();
                } else if (!headers.containsKey("authorization")) {
                    this.sendUnauthorized();
                } else {
                    this.decodeCredentials(headers.get("authorization"));
                    try {
                        this.session = ExchangeSessionFactory.getInstance(this.userName, this.password);
                        this.handleRequest(command, path, headers, content);
                    }
                    catch (DavMailAuthenticationException e) {
                        if (Settings.getBooleanProperty("davmail.enableKerberos")) {
                            throw new HttpServerErrorException("Kerberos authentication failed");
                        }
                        this.sendUnauthorized();
                    }
                }
                this.os.flush();
                DavGatewayTray.resetIcon();
            }
        }
        catch (SocketTimeoutException e) {
            DavGatewayTray.debug(new BundleMessage("LOG_CLOSE_CONNECTION_ON_TIMEOUT", new Object[0]));
        }
        catch (SocketException e) {
            DavGatewayTray.debug(new BundleMessage("LOG_CONNECTION_CLOSED", new Object[0]));
        }
        catch (Exception e) {
            if (!(e instanceof HttpNotFoundException)) {
                DavGatewayTray.log(e);
            }
            try {
                this.sendErr(e);
            }
            catch (IOException e2) {
                DavGatewayTray.debug(new BundleMessage("LOG_EXCEPTION_SENDING_ERROR_TO_CLIENT", new Object[0]), e2);
            }
        }
        finally {
            this.close();
        }
        DavGatewayTray.resetIcon();
    }

    public void handleRequest(String command, String path, Map<String, String> headers, String body) throws IOException {
        CaldavRequest request = new CaldavRequest(command, path, headers, body);
        if (request.isOptions()) {
            this.sendOptions();
        } else if (request.isPropFind() && request.isRoot()) {
            this.sendRoot(request);
        } else if (request.isGet() && request.isRoot()) {
            this.sendGetRoot();
        } else if (request.isPath(1, "principals")) {
            this.handlePrincipals(request);
        } else if (request.isPath(1, "users")) {
            if (request.isPropFind() && request.isPathLength(3)) {
                this.sendUserRoot(request);
            } else {
                this.handleFolderOrItem(request);
            }
        } else if (request.isPath(1, "public")) {
            this.handleFolderOrItem(request);
        } else if (request.isPath(1, "directory")) {
            this.sendDirectory(request);
        } else if (request.isPath(1, ".well-known")) {
            this.sendWellKnown();
        } else {
            this.sendUnsupported(request);
        }
    }

    protected void handlePrincipals(CaldavRequest request) throws IOException {
        if (request.isPath(2, "users")) {
            if (request.isPropFind() && request.isPathLength(4)) {
                this.sendPrincipal(request, "users", URIUtil.decode((String)request.getPathElement(3)));
            } else if (request.isReport() && request.isPathLength(3)) {
                this.sendPrincipal(request, "users", this.session.getEmail());
            } else if (request.isPropFind() && request.isPathLength(3)) {
                this.sendPrincipalsFolder(request);
            } else {
                this.sendUnsupported(request);
            }
        } else if (request.isPath(2, "public")) {
            StringBuilder prefixBuffer = new StringBuilder("public");
            for (int i = 3; i < request.getPathLength() - 1; ++i) {
                prefixBuffer.append('/').append(request.getPathElement(i));
            }
            this.sendPrincipal(request, URIUtil.decode((String)prefixBuffer.toString()), URIUtil.decode((String)request.getLastPath()));
        } else {
            this.sendUnsupported(request);
        }
    }

    protected void handleFolderOrItem(CaldavRequest request) throws IOException {
        String lastPath = StringUtil.xmlDecode(request.getLastPath());
        if (request.isPropFind() && "inbox".equals(lastPath)) {
            this.sendInbox(request);
        } else if (request.isPropFind() && "outbox".equals(lastPath)) {
            this.sendOutbox(request);
        } else if (request.isPost() && "outbox".equals(lastPath)) {
            if (request.isFreeBusy()) {
                this.sendFreeBusy(request.getBody());
            } else {
                int status = this.session.sendEvent(request.getBody());
                this.sendHttpResponse(status);
            }
        } else if (request.isPropFind()) {
            this.sendFolderOrItem(request);
        } else if (request.isPropPatch()) {
            this.patchCalendar(request);
        } else if (request.isReport()) {
            this.reportItems(request);
        } else if (request.isPut()) {
            String etag = request.getHeader("if-match");
            String noneMatch = request.getHeader("if-none-match");
            ExchangeSession.ItemResult itemResult = this.session.createOrUpdateItem(request.getFolderPath(), lastPath, request.getBody(), etag, noneMatch);
            this.sendHttpResponse(itemResult.status, this.buildEtagHeader(itemResult.etag), null, "", true);
        } else if (request.isDelete()) {
            if (request.getFolderPath().endsWith("inbox")) {
                this.session.processItem(request.getFolderPath(), lastPath);
            } else {
                this.session.deleteItem(request.getFolderPath(), lastPath);
            }
            this.sendHttpResponse(200);
        } else if (request.isGet()) {
            if (request.path.endsWith("/")) {
                String folderPath = request.getFolderPath();
                ExchangeSession.Folder folder = this.session.getFolder(folderPath);
                if (folder.isContact()) {
                    List<ExchangeSession.Contact> contacts = this.session.getAllContacts(folderPath);
                    ChunkedResponse response = new ChunkedResponse(200, "text/vcard;charset=UTF-8");
                    for (ExchangeSession.Contact contact : contacts) {
                        String contactBody = contact.getBody();
                        if (contactBody == null) continue;
                        response.append(contactBody);
                        response.append("\n");
                    }
                    response.close();
                } else if (folder.isCalendar() || folder.isTask()) {
                    List<ExchangeSession.Event> events = this.session.getAllEvents(folderPath);
                    ChunkedResponse response = new ChunkedResponse(200, "text/calendar;charset=UTF-8");
                    response.append("BEGIN:VCALENDAR\r\n");
                    response.append("VERSION:2.0\r\n");
                    response.append("PRODID:-//davmail.sf.net/NONSGML DavMail Calendar V1.1//EN\r\n");
                    response.append("METHOD:PUBLISH\r\n");
                    for (ExchangeSession.Event event : events) {
                        String icsContent = StringUtil.getToken(event.getBody(), "BEGIN:VTIMEZONE", "END:VCALENDAR");
                        if (icsContent != null) {
                            response.append("BEGIN:VTIMEZONE");
                            response.append(icsContent);
                            continue;
                        }
                        icsContent = StringUtil.getToken(event.getBody(), "BEGIN:VEVENT", "END:VCALENDAR");
                        if (icsContent == null) continue;
                        response.append("BEGIN:VEVENT");
                        response.append(icsContent);
                    }
                    response.append("END:VCALENDAR");
                    response.close();
                } else {
                    this.sendHttpResponse(200, this.buildEtagHeader(folder.etag), "text/html", (byte[])null, true);
                }
            } else {
                ExchangeSession.Item item = this.session.getItem(request.getFolderPath(), lastPath);
                this.sendHttpResponse(200, this.buildEtagHeader(item.getEtag()), item.getContentType(), item.getBody(), true);
            }
        } else if (request.isHead()) {
            ExchangeSession.Item item = this.session.getItem(request.getFolderPath(), lastPath);
            this.sendHttpResponse(200, this.buildEtagHeader(item.getEtag()), item.getContentType(), (byte[])null, true);
        } else if (request.isMkCalendar()) {
            HashMap<String, String> properties = new HashMap<String, String>();
            int status = this.session.createCalendarFolder(request.getFolderPath(), properties);
            this.sendHttpResponse(status, null);
        } else if (request.isMove()) {
            String destinationUrl = request.getHeader("destination");
            this.session.moveItem(request.path, URIUtil.decode((String)new URL(destinationUrl).getPath()));
            this.sendHttpResponse(201, null);
        } else {
            this.sendUnsupported(request);
        }
    }

    protected HashMap<String, String> buildEtagHeader(String etag) {
        if (etag != null) {
            HashMap<String, String> etagHeader = new HashMap<String, String>();
            etagHeader.put("ETag", etag);
            return etagHeader;
        }
        return null;
    }

    private void appendContactsResponses(CaldavResponse response, CaldavRequest request, List<ExchangeSession.Contact> contacts) throws IOException {
        int size = contacts.size();
        int count = 0;
        for (ExchangeSession.Contact contact : contacts) {
            DavGatewayTray.debug(new BundleMessage("LOG_LISTING_ITEM", ++count, size));
            DavGatewayTray.switchIcon();
            this.appendItemResponse(response, request, contact);
        }
    }

    protected void appendEventsResponses(CaldavResponse response, CaldavRequest request, List<ExchangeSession.Event> events) throws IOException {
        int size = events.size();
        int count = 0;
        for (ExchangeSession.Event event : events) {
            DavGatewayTray.debug(new BundleMessage("LOG_LISTING_ITEM", ++count, size));
            DavGatewayTray.switchIcon();
            this.appendItemResponse(response, request, event);
        }
    }

    protected void appendItemResponse(CaldavResponse response, CaldavRequest request, ExchangeSession.Item item) throws IOException {
        StringBuilder eventPath = new StringBuilder();
        eventPath.append(CaldavConnection.encodePath(request, request.getPath()));
        if (eventPath.charAt(eventPath.length() - 1) != '/') {
            eventPath.append('/');
        }
        String itemName = StringUtil.xmlEncode(item.getName());
        eventPath.append(URIUtil.encodeWithinQuery((String)itemName));
        response.startResponse(eventPath.toString());
        response.startPropstat();
        if (request.hasProperty("calendar-data") && item instanceof ExchangeSession.Event) {
            response.appendCalendarData(item.getBody());
        }
        if (request.hasProperty("address-data") && item instanceof ExchangeSession.Contact) {
            response.appendContactData(item.getBody());
        }
        if (request.hasProperty("getcontenttype")) {
            if (item instanceof ExchangeSession.Event) {
                response.appendProperty("D:getcontenttype", "text/calendar; component=vevent");
            } else if (item instanceof ExchangeSession.Contact) {
                response.appendProperty("D:getcontenttype", "text/vcard");
            }
        }
        if (request.hasProperty("getetag")) {
            response.appendProperty("D:getetag", item.getEtag());
        }
        if (request.hasProperty("resourcetype")) {
            response.appendProperty("D:resourcetype");
        }
        if (request.hasProperty("displayname")) {
            response.appendProperty("D:displayname", itemName);
        }
        response.endPropStatOK();
        response.endResponse();
    }

    public void appendFolderOrItem(CaldavResponse response, CaldavRequest request, ExchangeSession.Folder folder, String subFolder) throws IOException {
        response.startResponse(CaldavConnection.encodePath(request, request.getPath(subFolder)));
        response.startPropstat();
        if (request.hasProperty("resourcetype")) {
            if (folder.isContact()) {
                response.appendProperty("D:resourcetype", "<D:collection/><E:addressbook/>");
            } else if (folder.isCalendar() || folder.isTask()) {
                response.appendProperty("D:resourcetype", "<D:collection/><C:calendar/>");
            } else {
                response.appendProperty("D:resourcetype", "<D:collection/>");
            }
        }
        if (request.hasProperty("owner")) {
            if ("users".equals(request.getPathElement(1))) {
                response.appendHrefProperty("D:owner", "/principals/users/" + request.getPathElement(2));
            } else {
                response.appendHrefProperty("D:owner", "/principals" + request.getPath());
            }
        }
        if (request.hasProperty("getcontenttype")) {
            if (folder.isContact()) {
                response.appendProperty("D:getcontenttype", "text/x-vcard");
            } else if (folder.isCalendar()) {
                response.appendProperty("D:getcontenttype", "text/calendar; component=vevent");
            } else if (folder.isTask()) {
                response.appendProperty("D:getcontenttype", "text/calendar; component=vtodo");
            }
        }
        if (request.hasProperty("getetag")) {
            response.appendProperty("D:getetag", folder.etag);
        }
        if (request.hasProperty("getctag")) {
            response.appendProperty("CS:getctag", "CS=\"http://calendarserver.org/ns/\"", IOUtil.encodeBase64AsString(folder.ctag));
        }
        if (request.hasProperty("displayname")) {
            if (subFolder == null || subFolder.length() == 0) {
                String displayname = request.getLastPath();
                if ("calendar".equals(displayname)) {
                    displayname = folder.displayName;
                }
                response.appendProperty("D:displayname", displayname);
            } else {
                response.appendProperty("D:displayname", subFolder);
            }
        }
        if (request.hasProperty("calendar-description")) {
            response.appendProperty("C:calendar-description", "");
        }
        if (request.hasProperty("supported-calendar-component-set")) {
            if (folder.isCalendar()) {
                response.appendProperty("C:supported-calendar-component-set", "<C:comp name=\"VEVENT\"/><C:comp name=\"VTODO\"/>");
            } else if (folder.isTask()) {
                response.appendProperty("C:supported-calendar-component-set", "<C:comp name=\"VTODO\"/>");
            }
        }
        if (request.hasProperty("current-user-privilege-set")) {
            response.appendProperty("D:current-user-privilege-set", "<D:privilege><D:read/><D:write/></D:privilege>");
        }
        response.endPropStatOK();
        response.endResponse();
    }

    public void appendInbox(CaldavResponse response, CaldavRequest request, String subFolder) throws IOException {
        String ctag = "0";
        String etag = "0";
        String folderPath = request.getFolderPath(subFolder);
        if (!this.session.isSharedFolder(folderPath)) {
            try {
                ExchangeSession.Folder folder = this.session.getFolder(folderPath);
                ctag = IOUtil.encodeBase64AsString(folder.ctag);
                etag = IOUtil.encodeBase64AsString(folder.etag);
            }
            catch (HttpException e) {
                DavGatewayTray.debug(new BundleMessage("LOG_ACCESS_FORBIDDEN", folderPath, e.getMessage()));
            }
        }
        response.startResponse(CaldavConnection.encodePath(request, request.getPath(subFolder)));
        response.startPropstat();
        if (request.hasProperty("resourcetype")) {
            response.appendProperty("D:resourcetype", "<D:collection/><C:schedule-inbox xmlns:C=\"urn:ietf:params:xml:ns:caldav\"/>");
        }
        if (request.hasProperty("getcontenttype")) {
            response.appendProperty("D:getcontenttype", "text/calendar; component=vevent");
        }
        if (request.hasProperty("getctag")) {
            response.appendProperty("CS:getctag", "CS=\"http://calendarserver.org/ns/\"", ctag);
        }
        if (request.hasProperty("getetag")) {
            response.appendProperty("D:getetag", etag);
        }
        if (request.hasProperty("displayname")) {
            response.appendProperty("D:displayname", "inbox");
        }
        response.endPropStatOK();
        response.endResponse();
    }

    public void appendOutbox(CaldavResponse response, CaldavRequest request, String subFolder) throws IOException {
        response.startResponse(CaldavConnection.encodePath(request, request.getPath(subFolder)));
        response.startPropstat();
        if (request.hasProperty("resourcetype")) {
            response.appendProperty("D:resourcetype", "<D:collection/><C:schedule-outbox xmlns:C=\"urn:ietf:params:xml:ns:caldav\"/>");
        }
        if (request.hasProperty("getctag")) {
            response.appendProperty("CS:getctag", "CS=\"http://calendarserver.org/ns/\"", "0");
        }
        if (request.hasProperty("getetag")) {
            response.appendProperty("D:getetag", "0");
        }
        if (request.hasProperty("displayname")) {
            response.appendProperty("D:displayname", "outbox");
        }
        response.endPropStatOK();
        response.endResponse();
    }

    public void sendGetRoot() throws IOException {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Connected to DavMail<br/>");
        buffer.append("UserName :").append(this.userName).append("<br/>");
        buffer.append("Email :").append(this.session.getEmail()).append("<br/>");
        this.sendHttpResponse(200, null, "text/html;charset=UTF-8", buffer.toString(), true);
    }

    public void sendInbox(CaldavRequest request) throws IOException {
        CaldavResponse response = new CaldavResponse(207);
        response.startMultistatus();
        this.appendInbox(response, request, null);
        if (!this.session.isSharedFolder(request.getFolderPath(null)) && request.getDepth() == 1 && !request.isLightning()) {
            try {
                DavGatewayTray.debug(new BundleMessage("LOG_SEARCHING_CALENDAR_MESSAGES", new Object[0]));
                List<ExchangeSession.Event> events = this.session.getEventMessages(request.getFolderPath());
                DavGatewayTray.debug(new BundleMessage("LOG_FOUND_CALENDAR_MESSAGES", events.size()));
                this.appendEventsResponses(response, request, events);
            }
            catch (HttpException e) {
                DavGatewayTray.debug(new BundleMessage("LOG_ACCESS_FORBIDDEN", request.getFolderPath(), e.getMessage()));
            }
        }
        response.endMultistatus();
        response.close();
    }

    public void sendOutbox(CaldavRequest request) throws IOException {
        CaldavResponse response = new CaldavResponse(207);
        response.startMultistatus();
        this.appendOutbox(response, request, null);
        response.endMultistatus();
        response.close();
    }

    public void sendFolderOrItem(CaldavRequest request) throws IOException {
        String folderPath = request.getFolderPath();
        ExchangeSession.Folder folder = this.session.getFolder(folderPath);
        List<ExchangeSession.Contact> contacts = null;
        List<ExchangeSession.Event> events = null;
        List<ExchangeSession.Folder> folderList = null;
        if (request.getDepth() == 1) {
            if (folder.isContact()) {
                contacts = this.session.getAllContacts(folderPath);
            } else if (folder.isCalendar() || folder.isTask()) {
                events = this.session.getAllEvents(folderPath);
                if (!folderPath.startsWith("/public")) {
                    folderList = this.session.getSubCalendarFolders(folderPath, false);
                }
            }
        }
        CaldavResponse response = new CaldavResponse(207);
        response.startMultistatus();
        this.appendFolderOrItem(response, request, folder, null);
        if (request.getDepth() == 1) {
            if (folder.isContact()) {
                this.appendContactsResponses(response, request, contacts);
            } else if (folder.isCalendar() || folder.isTask()) {
                this.appendEventsResponses(response, request, events);
                if (folderList != null) {
                    for (ExchangeSession.Folder subFolder : folderList) {
                        this.appendFolderOrItem(response, request, subFolder, subFolder.folderPath.substring(subFolder.folderPath.indexOf(47) + 1));
                    }
                }
            }
        }
        response.endMultistatus();
        response.close();
    }

    public void patchCalendar(CaldavRequest request) throws IOException {
        String targetPath;
        String displayname = request.getProperty("displayname");
        String folderPath = request.getFolderPath();
        if (displayname != null && !(targetPath = request.getParentFolderPath() + '/' + displayname).equals(folderPath)) {
            this.session.moveFolder(folderPath, targetPath);
        }
        CaldavResponse response = new CaldavResponse(207);
        response.startMultistatus();
        if (request.hasProperty("calendar-color") || request.hasProperty("calendar-order")) {
            response.startPropstat();
            if (request.hasProperty("calendar-color")) {
                response.appendProperty("x1:calendar-color", "x1=\"http://apple.com/ns/ical/\"", null);
            }
            if (request.hasProperty("calendar-order")) {
                response.appendProperty("x1:calendar-order", "x1=\"http://apple.com/ns/ical/\"", null);
            }
            response.endPropStatOK();
        }
        response.endMultistatus();
        response.close();
    }

    protected String getEventFileNameFromPath(String path) {
        int index = path.lastIndexOf(47);
        if (index < 0) {
            return null;
        }
        return StringUtil.xmlDecode(path.substring(index + 1));
    }

    public void reportItems(CaldavRequest request) throws IOException {
        List<ExchangeSession.Event> events;
        String folderPath = request.getFolderPath();
        ArrayList<String> notFound = new ArrayList<String>();
        CaldavResponse response = new CaldavResponse(207);
        response.startMultistatus();
        if (request.isMultiGet()) {
            int count = 0;
            int total = request.getHrefs().size();
            for (String href : request.getHrefs()) {
                DavGatewayTray.debug(new BundleMessage("LOG_REPORT_ITEM", ++count, total));
                DavGatewayTray.switchIcon();
                String eventName = this.getEventFileNameFromPath(href);
                try {
                    ExchangeSession.Item item;
                    if (eventName == null || eventName.length() <= 0 || "inbox".equals(eventName) || "calendar".equals(eventName)) continue;
                    try {
                        item = this.session.getItem(folderPath, eventName);
                    }
                    catch (HttpNotFoundException e) {
                        if (request.isBrokenLightning() && eventName.indexOf(37) >= 0) {
                            item = this.session.getItem(folderPath, URIUtil.decode((String)StringUtil.encodePlusSign(eventName)));
                        }
                        throw e;
                    }
                    this.appendItemResponse(response, request, item);
                }
                catch (SocketException e) {
                    throw e;
                }
                catch (Exception e) {
                    this.wireLogger.debug((Object)e.getMessage(), (Throwable)e);
                    DavGatewayTray.warn(new BundleMessage("LOG_ITEM_NOT_AVAILABLE", eventName, href));
                    notFound.add(href);
                }
            }
        } else if (request.isPath(1, "users") && request.isPath(3, "inbox")) {
            events = this.session.getEventMessages(request.getFolderPath());
            this.appendEventsResponses(response, request, events);
        } else {
            ExchangeSession.Folder folder = this.session.getFolder(folderPath);
            if (folder.isContact()) {
                List<ExchangeSession.Contact> contacts = this.session.getAllContacts(folderPath);
                this.appendContactsResponses(response, request, contacts);
            } else {
                events = request.vTodoOnly ? this.session.searchTasksOnly(request.getFolderPath()) : (request.vEventOnly ? this.session.searchEventsOnly(request.getFolderPath(), request.timeRangeStart, request.timeRangeEnd) : this.session.searchEvents(request.getFolderPath(), request.timeRangeStart, request.timeRangeEnd));
                this.appendEventsResponses(response, request, events);
            }
        }
        for (String href : notFound) {
            response.startResponse(CaldavConnection.encodePath(request, href));
            response.appendPropstatNotFound();
            response.endResponse();
        }
        response.endMultistatus();
        response.close();
    }

    public void sendPrincipalsFolder(CaldavRequest request) throws IOException {
        CaldavResponse response = new CaldavResponse(207);
        response.startMultistatus();
        response.startResponse(CaldavConnection.encodePath(request, request.getPath()));
        response.startPropstat();
        if (request.hasProperty("current-user-principal")) {
            response.appendHrefProperty("D:current-user-principal", CaldavConnection.encodePath(request, "/principals/users/" + this.session.getEmail()));
        }
        response.endPropStatOK();
        response.endResponse();
        response.endMultistatus();
        response.close();
    }

    public void sendUserRoot(CaldavRequest request) throws IOException {
        CaldavResponse response = new CaldavResponse(207);
        response.startMultistatus();
        response.startResponse(CaldavConnection.encodePath(request, request.getPath()));
        response.startPropstat();
        if (request.hasProperty("resourcetype")) {
            response.appendProperty("D:resourcetype", "<D:collection/>");
        }
        if (request.hasProperty("displayname")) {
            response.appendProperty("D:displayname", request.getLastPath());
        }
        if (request.hasProperty("getctag")) {
            ExchangeSession.Folder rootFolder = this.session.getFolder("");
            response.appendProperty("CS:getctag", "CS=\"http://calendarserver.org/ns/\"", IOUtil.encodeBase64AsString(rootFolder.ctag));
        }
        response.endPropStatOK();
        if (request.getDepth() == 1) {
            this.appendInbox(response, request, "inbox");
            this.appendOutbox(response, request, "outbox");
            this.appendFolderOrItem(response, request, this.session.getFolder(request.getFolderPath("calendar")), "calendar");
            this.appendFolderOrItem(response, request, this.session.getFolder(request.getFolderPath("contacts")), "contacts");
        }
        response.endResponse();
        response.endMultistatus();
        response.close();
    }

    public void sendRoot(CaldavRequest request) throws IOException {
        CaldavResponse response = new CaldavResponse(207);
        response.startMultistatus();
        response.startResponse("/");
        response.startPropstat();
        if (request.hasProperty("principal-collection-set")) {
            response.appendHrefProperty("D:principal-collection-set", "/principals/users/");
        }
        if (request.hasProperty("displayname")) {
            response.appendProperty("D:displayname", "ROOT");
        }
        if (request.hasProperty("resourcetype")) {
            response.appendProperty("D:resourcetype", "<D:collection/>");
        }
        if (request.hasProperty("current-user-principal")) {
            response.appendHrefProperty("D:current-user-principal", CaldavConnection.encodePath(request, "/principals/users/" + this.session.getEmail()));
        }
        response.endPropStatOK();
        response.endResponse();
        if (request.depth == 1) {
            response.startResponse("/users/" + this.session.getEmail() + "/calendar");
            response.startPropstat();
            if (request.hasProperty("resourcetype")) {
                response.appendProperty("D:resourcetype", "<D:collection/><C:calendar xmlns:C=\"urn:ietf:params:xml:ns:caldav\"/>");
            }
            if (request.hasProperty("displayname")) {
                response.appendProperty("D:displayname", this.session.getEmail());
            }
            if (request.hasProperty("supported-calendar-component-set")) {
                response.appendProperty("C:supported-calendar-component-set", "<C:comp name=\"VEVENT\"/>");
            }
            response.endPropStatOK();
            response.endResponse();
            response.startResponse("/users");
            response.startPropstat();
            if (request.hasProperty("displayname")) {
                response.appendProperty("D:displayname", "users");
            }
            if (request.hasProperty("resourcetype")) {
                response.appendProperty("D:resourcetype", "<D:collection/>");
            }
            response.endPropStatOK();
            response.endResponse();
            response.startResponse("/principals");
            response.startPropstat();
            if (request.hasProperty("displayname")) {
                response.appendProperty("D:displayname", "principals");
            }
            if (request.hasProperty("resourcetype")) {
                response.appendProperty("D:resourcetype", "<D:collection/>");
            }
            response.endPropStatOK();
            response.endResponse();
        }
        response.endMultistatus();
        response.close();
    }

    public void sendDirectory(CaldavRequest request) throws IOException {
        CaldavResponse response = new CaldavResponse(207);
        response.startMultistatus();
        response.startResponse("/directory/");
        response.startPropstat();
        if (request.hasProperty("current-user-privilege-set")) {
            response.appendProperty("D:current-user-privilege-set", "<D:privilege><D:read/></D:privilege>");
        }
        response.endPropStatOK();
        response.endResponse();
        response.endMultistatus();
        response.close();
    }

    public void sendWellKnown() throws IOException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Location", "/");
        this.sendHttpResponse(301, headers);
    }

    public void sendPrincipal(CaldavRequest request, String prefix, String principal) throws IOException {
        String actualPrincipal = principal;
        if ("users".equals(prefix) && (principal.equalsIgnoreCase(this.session.getAlias()) || principal.equalsIgnoreCase(this.session.getAliasFromLogin()))) {
            actualPrincipal = this.session.getEmail();
        }
        CaldavResponse response = new CaldavResponse(207);
        response.startMultistatus();
        response.startResponse(CaldavConnection.encodePath(request, "/principals/" + prefix + '/' + principal));
        response.startPropstat();
        if (request.hasProperty("principal-URL") && request.isIcal5()) {
            response.appendHrefProperty("D:principal-URL", CaldavConnection.encodePath(request, "/principals/" + prefix + '/' + actualPrincipal));
        }
        if (request.hasProperty("calendar-home-set")) {
            if ("users".equals(prefix)) {
                response.appendHrefProperty("C:calendar-home-set", CaldavConnection.encodePath(request, "/users/" + actualPrincipal + "/calendar/"));
            } else {
                response.appendHrefProperty("C:calendar-home-set", CaldavConnection.encodePath(request, '/' + prefix + '/' + actualPrincipal));
            }
        }
        if (request.hasProperty("calendar-user-address-set") && "users".equals(prefix)) {
            response.appendHrefProperty("C:calendar-user-address-set", "mailto:" + actualPrincipal);
        }
        if (request.hasProperty("addressbook-home-set")) {
            if (request.isUserAgent("Address%20Book") || request.isUserAgent("Darwin")) {
                response.appendHrefProperty("E:addressbook-home-set", CaldavConnection.encodePath(request, '/' + prefix + '/' + actualPrincipal + '/'));
            } else if ("users".equals(prefix)) {
                response.appendHrefProperty("E:addressbook-home-set", CaldavConnection.encodePath(request, "/users/" + actualPrincipal + "/contacts/"));
            } else {
                response.appendHrefProperty("E:addressbook-home-set", CaldavConnection.encodePath(request, '/' + prefix + '/' + actualPrincipal + '/'));
            }
        }
        if ("users".equals(prefix)) {
            if (request.hasProperty("schedule-inbox-URL")) {
                response.appendHrefProperty("C:schedule-inbox-URL", CaldavConnection.encodePath(request, "/users/" + actualPrincipal + "/inbox/"));
            }
            if (request.hasProperty("schedule-outbox-URL")) {
                response.appendHrefProperty("C:schedule-outbox-URL", CaldavConnection.encodePath(request, "/users/" + actualPrincipal + "/outbox/"));
            }
        } else {
            if (request.isLightning() && request.hasProperty("schedule-inbox-URL")) {
                response.appendHrefProperty("C:schedule-inbox-URL", "/");
            }
            if (request.hasProperty("schedule-outbox-URL")) {
                response.appendHrefProperty("C:schedule-outbox-URL", CaldavConnection.encodePath(request, "/users/" + this.session.getEmail() + "/outbox/"));
            }
        }
        if (request.hasProperty("displayname")) {
            response.appendProperty("D:displayname", actualPrincipal);
        }
        if (request.hasProperty("resourcetype")) {
            response.appendProperty("D:resourcetype", "<D:collection/><D:principal/>");
        }
        if (request.hasProperty("supported-report-set")) {
            response.appendProperty("D:supported-report-set", "<D:supported-report><D:report><C:calendar-multiget/></D:report></D:supported-report>");
        }
        response.endPropStatOK();
        response.endResponse();
        response.endMultistatus();
        response.close();
    }

    public void sendFreeBusy(String body) throws IOException {
        String line;
        HashMap<String, String> valueMap = new HashMap<String, String>();
        ArrayList<String> attendees = new ArrayList<String>();
        HashMap<String, String> attendeeKeyMap = new HashMap<String, String>();
        ICSBufferedReader reader = new ICSBufferedReader(new StringReader(body));
        while ((line = reader.readLine()) != null) {
            int index = line.indexOf(58);
            if (index <= 0) {
                throw new DavMailException("EXCEPTION_INVALID_REQUEST", body);
            }
            String fullkey = line.substring(0, index);
            String value = line.substring(index + 1);
            int semicolonIndex = fullkey.indexOf(59);
            String key = semicolonIndex > 0 ? fullkey.substring(0, semicolonIndex) : fullkey;
            if ("ATTENDEE".equals(key)) {
                attendees.add(value);
                attendeeKeyMap.put(value, fullkey);
                continue;
            }
            valueMap.put(key, value);
        }
        HashMap<String, ExchangeSession.FreeBusy> freeBusyMap = new HashMap<String, ExchangeSession.FreeBusy>();
        for (String attendee : attendees) {
            ExchangeSession.FreeBusy freeBusy = this.session.getFreebusy(attendee, (String)valueMap.get("DTSTART"), (String)valueMap.get("DTEND"));
            if (freeBusy == null) continue;
            freeBusyMap.put(attendee, freeBusy);
        }
        CaldavResponse response = new CaldavResponse(200);
        response.startScheduleResponse();
        for (Map.Entry entry : freeBusyMap.entrySet()) {
            String attendee = (String)entry.getKey();
            response.startRecipientResponse(attendee);
            StringBuilder ics = new StringBuilder();
            ics.append("BEGIN:VCALENDAR").append('\r').append('\n').append("VERSION:2.0").append('\r').append('\n').append("PRODID:-//davmail.sf.net/NONSGML DavMail Calendar V1.1//EN").append('\r').append('\n').append("METHOD:REPLY").append('\r').append('\n').append("BEGIN:VFREEBUSY").append('\r').append('\n').append("DTSTAMP:").append((String)valueMap.get("DTSTAMP")).append("").append('\r').append('\n').append("ORGANIZER:").append((String)valueMap.get("ORGANIZER")).append("").append('\r').append('\n').append("DTSTART:").append((String)valueMap.get("DTSTART")).append("").append('\r').append('\n').append("DTEND:").append((String)valueMap.get("DTEND")).append("").append('\r').append('\n').append("UID:").append((String)valueMap.get("UID")).append("").append('\r').append('\n').append((String)attendeeKeyMap.get(attendee)).append(':').append(attendee).append("").append('\r').append('\n');
            ((ExchangeSession.FreeBusy)entry.getValue()).appendTo(ics);
            ics.append("END:VFREEBUSY").append('\r').append('\n').append("END:VCALENDAR");
            response.appendCalendarData(ics.toString());
            response.endRecipientResponse();
        }
        response.endScheduleResponse();
        response.close();
    }

    public void sendErr(Exception e) throws IOException {
        String message = e.getMessage();
        if (message == null) {
            message = e.toString();
        }
        if (e instanceof HttpNotFoundException) {
            this.sendErr(404, message);
        } else if (e instanceof HttpPreconditionFailedException) {
            this.sendErr(412, message);
        } else {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.sendErr(503, message);
        }
    }

    public void sendUnsupported(CaldavRequest request) throws IOException {
        BundleMessage message = new BundleMessage("LOG_UNSUPPORTED_REQUEST", request);
        DavGatewayTray.error(message);
        this.sendErr(400, message.format());
    }

    public void sendErr(int status, String message) throws IOException {
        this.sendHttpResponse(status, null, "text/plain;charset=UTF-8", message, false);
    }

    public void sendOptions() throws IOException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Allow", "OPTIONS, PROPFIND, HEAD, GET, REPORT, PROPPATCH, PUT, DELETE, POST");
        this.sendHttpResponse(200, headers);
    }

    public void sendUnauthorized() throws IOException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("WWW-Authenticate", "Basic realm=\"" + BundleMessage.format("UI_DAVMAIL_GATEWAY", new Object[0]) + '\"');
        this.sendHttpResponse(401, headers, null, (byte[])null, true);
    }

    public void sendHttpResponse(int status) throws IOException {
        this.sendHttpResponse(status, null, null, (byte[])null, true);
    }

    public void sendHttpResponse(int status, Map<String, String> headers) throws IOException {
        this.sendHttpResponse(status, headers, null, (byte[])null, true);
    }

    public void sendChunkedHttpResponse(int status, String contentType) throws IOException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Transfer-Encoding", "chunked");
        this.sendHttpResponse(status, headers, contentType, (byte[])null, true);
    }

    public void sendHttpResponse(int status, Map<String, String> headers, String contentType, String content, boolean keepAlive) throws IOException {
        this.sendHttpResponse(status, headers, contentType, content.getBytes("UTF-8"), keepAlive);
    }

    public void sendHttpResponse(int status, Map<String, String> headers, String contentType, byte[] content, boolean keepAlive) throws IOException {
        this.sendClient("HTTP/1.1 " + status + ' ' + HttpStatus.getStatusText((int)status));
        if (status != 401) {
            this.sendClient("Server: DavMail Gateway " + DavGateway.getCurrentVersion());
            this.sendClient("DAV: 1, calendar-access, calendar-schedule, calendarserver-private-events, addressbook");
            SimpleDateFormat formatter = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.ENGLISH);
            formatter.setTimeZone(ExchangeSession.GMT_TIMEZONE);
            String now = formatter.format(new Date());
            this.sendClient("Date: " + now);
            this.sendClient("Expires: " + now);
            this.sendClient("Cache-Control: private, max-age=0");
        }
        if (headers != null) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                this.sendClient(header.getKey() + ": " + header.getValue());
            }
        }
        if (contentType != null) {
            this.sendClient("Content-Type: " + contentType);
        }
        this.closed = this.closed || !keepAlive;
        this.sendClient("Connection: " + (this.closed ? "close" : "keep-alive"));
        if (content != null && content.length > 0) {
            this.sendClient("Content-Length: " + content.length);
        } else if (headers == null || !"chunked".equals(headers.get("Transfer-Encoding"))) {
            this.sendClient("Content-Length: 0");
        }
        this.sendClient("");
        if (content != null && content.length > 0) {
            if (this.wireLogger.isDebugEnabled()) {
                this.wireLogger.debug((Object)("> " + new String(content, "UTF-8")));
            }
            this.sendClient(content);
        }
    }

    protected void decodeCredentials(String authorization) throws IOException {
        String decodedCredentials;
        int index = authorization.indexOf(32);
        if (index > 0) {
            String mode = authorization.substring(0, index).toLowerCase();
            if (!"basic".equals(mode)) {
                throw new DavMailException("EXCEPTION_UNSUPPORTED_AUTHORIZATION_MODE", mode);
            }
            String encodedCredentials = authorization.substring(index + 1);
            decodedCredentials = IOUtil.decodeBase64AsString(encodedCredentials);
            if ((index = decodedCredentials.indexOf(58)) <= 0) {
                throw new DavMailException("EXCEPTION_INVALID_CREDENTIALS", new Object[0]);
            }
        } else {
            throw new DavMailException("EXCEPTION_INVALID_CREDENTIALS", new Object[0]);
        }
        this.userName = decodedCredentials.substring(0, index);
        this.password = decodedCredentials.substring(index + 1);
    }

    static {
        ical_allowed_abs_path.or(URI.allowed_abs_path);
        ical_allowed_abs_path.clear(64);
    }

    protected class CaldavResponse
    extends ChunkedResponse {
        protected CaldavResponse(int status) throws IOException {
            super(status, "text/xml;charset=UTF-8");
            this.writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        }

        public void startMultistatus() throws IOException {
            this.writer.write("<D:multistatus xmlns:D=\"DAV:\" xmlns:C=\"urn:ietf:params:xml:ns:caldav\" xmlns:E=\"urn:ietf:params:xml:ns:carddav\">");
        }

        public void startResponse(String href) throws IOException {
            this.writer.write("<D:response>");
            this.writer.write("<D:href>");
            this.writer.write(StringUtil.xmlEncode(href));
            this.writer.write("</D:href>");
        }

        public void startPropstat() throws IOException {
            this.writer.write("<D:propstat>");
            this.writer.write("<D:prop>");
        }

        public void appendCalendarData(String ics) throws IOException {
            if (ics != null && ics.length() > 0) {
                this.writer.write("<C:calendar-data xmlns:C=\"urn:ietf:params:xml:ns:caldav\"");
                this.writer.write(" C:content-type=\"text/calendar\" C:version=\"2.0\">");
                this.writer.write(StringUtil.xmlEncode(ics));
                this.writer.write("</C:calendar-data>");
            }
        }

        public void appendContactData(String vcard) throws IOException {
            if (vcard != null && vcard.length() > 0) {
                this.writer.write("<E:address-data>");
                this.writer.write(StringUtil.xmlEncode(vcard));
                this.writer.write("</E:address-data>");
            }
        }

        public void appendHrefProperty(String propertyName, String propertyValue) throws IOException {
            this.appendProperty(propertyName, null, "<D:href>" + StringUtil.xmlEncode(propertyValue) + "</D:href>");
        }

        public void appendProperty(String propertyName) throws IOException {
            this.appendProperty(propertyName, null);
        }

        public void appendProperty(String propertyName, String propertyValue) throws IOException {
            this.appendProperty(propertyName, null, propertyValue);
        }

        public void appendProperty(String propertyName, String namespace, String propertyValue) throws IOException {
            if (propertyValue != null) {
                this.writer.write(60);
                this.writer.write(propertyName);
                if (namespace != null) {
                    this.writer.write("  xmlns:");
                    this.writer.write(namespace);
                }
                this.writer.write(62);
                this.writer.write(propertyValue);
                this.writer.write("</");
                this.writer.write(propertyName);
                this.writer.write(62);
            } else {
                this.writer.write(60);
                this.writer.write(propertyName);
                if (namespace != null) {
                    this.writer.write("  xmlns:");
                    this.writer.write(namespace);
                }
                this.writer.write("/>");
            }
        }

        public void endPropStatOK() throws IOException {
            this.writer.write("</D:prop><D:status>HTTP/1.1 200 OK</D:status></D:propstat>");
        }

        public void appendPropstatNotFound() throws IOException {
            this.writer.write("<D:propstat><D:status>HTTP/1.1 404 Not Found</D:status></D:propstat>");
        }

        public void endResponse() throws IOException {
            this.writer.write("</D:response>");
        }

        public void endMultistatus() throws IOException {
            this.writer.write("</D:multistatus>");
        }

        public void startScheduleResponse() throws IOException {
            this.writer.write("<C:schedule-response xmlns:D=\"DAV:\" xmlns:C=\"urn:ietf:params:xml:ns:caldav\">");
        }

        public void startRecipientResponse(String recipient) throws IOException {
            this.writer.write("<C:response><C:recipient><D:href>");
            this.writer.write(recipient);
            this.writer.write("</D:href></C:recipient><C:request-status>2.0;Success</C:request-status>");
        }

        public void endRecipientResponse() throws IOException {
            this.writer.write("</C:response>");
        }

        public void endScheduleResponse() throws IOException {
            this.writer.write("</C:schedule-response>");
        }
    }

    protected class ChunkedResponse {
        Writer writer;

        protected ChunkedResponse(int status, String contentType) throws IOException {
            this.writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new OutputStream(){

                public void write(byte[] data, int offset, int length) throws IOException {
                    CaldavConnection.this.sendClient(Integer.toHexString(length));
                    CaldavConnection.this.sendClient(data, offset, length);
                    if (CaldavConnection.this.wireLogger.isDebugEnabled()) {
                        StringBuilder logBuffer = new StringBuilder("> ");
                        logBuffer.append(new String(data, offset, length, "UTF-8"));
                        CaldavConnection.this.wireLogger.debug((Object)logBuffer.toString());
                    }
                    CaldavConnection.this.sendClient("");
                }

                public void write(int b) throws IOException {
                    throw new UnsupportedOperationException();
                }

                public void close() throws IOException {
                    CaldavConnection.this.sendClient("0");
                    CaldavConnection.this.sendClient("");
                }
            }), "UTF-8");
            CaldavConnection.this.sendChunkedHttpResponse(status, contentType);
        }

        public void append(String data) throws IOException {
            this.writer.write(data);
        }

        public void close() throws IOException {
            this.writer.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class CaldavRequest {
        protected final String command;
        protected final String path;
        protected final String[] pathElements;
        protected final Map<String, String> headers;
        protected int depth;
        protected final String body;
        protected final HashMap<String, String> properties = new HashMap();
        protected HashSet<String> hrefs;
        protected boolean isMultiGet;
        protected String timeRangeStart;
        protected String timeRangeEnd;
        protected boolean vTodoOnly;
        protected boolean vEventOnly;

        protected CaldavRequest(String command, String path, Map<String, String> headers, String body) throws IOException {
            this.command = command;
            this.path = path.replaceAll("//", "/");
            this.pathElements = this.path.split("/");
            this.headers = headers;
            this.buildDepth();
            this.body = body;
            if (this.isPropFind() || this.isReport() || this.isMkCalendar() || this.isPropPatch()) {
                this.parseXmlBody();
            }
        }

        public boolean isOptions() {
            return "OPTIONS".equals(this.command);
        }

        public boolean isPropFind() {
            return "PROPFIND".equals(this.command);
        }

        public boolean isPropPatch() {
            return "PROPPATCH".equals(this.command);
        }

        public boolean isReport() {
            return "REPORT".equals(this.command);
        }

        public boolean isGet() {
            return "GET".equals(this.command);
        }

        public boolean isHead() {
            return "HEAD".equals(this.command);
        }

        public boolean isPut() {
            return "PUT".equals(this.command);
        }

        public boolean isPost() {
            return "POST".equals(this.command);
        }

        public boolean isDelete() {
            return "DELETE".equals(this.command);
        }

        public boolean isMkCalendar() {
            return "MKCALENDAR".equals(this.command);
        }

        public boolean isMove() {
            return "MOVE".equals(this.command);
        }

        public boolean isFolder() {
            return this.path.endsWith("/") || this.isPropFind() || this.isReport() || this.isPropPatch() || this.isOptions() || this.isPost();
        }

        public boolean isRoot() {
            return this.pathElements.length == 0 || this.pathElements.length == 1;
        }

        public boolean isPathLength(int length) {
            return this.pathElements.length == length;
        }

        public int getPathLength() {
            return this.pathElements.length;
        }

        public String getPath() {
            return this.path;
        }

        public String getPath(String subFolder) {
            String folderPath = subFolder == null || subFolder.length() == 0 ? this.path : (this.path.endsWith("/") ? this.path + subFolder : this.path + '/' + subFolder);
            if (folderPath.endsWith("/")) {
                return folderPath;
            }
            return folderPath + '/';
        }

        public boolean isPath(int index, String value) {
            return value != null && value.equals(this.getPathElement(index));
        }

        protected String getPathElement(int index) {
            if (index < this.pathElements.length) {
                return this.pathElements[index];
            }
            return null;
        }

        public String getLastPath() {
            return this.getPathElement(this.getPathLength() - 1);
        }

        protected boolean isBrokenHrefEncoding() {
            return this.isUserAgent("DAVKit/3") || this.isUserAgent("eM Client/3") || this.isBrokenLightning();
        }

        protected boolean isBrokenLightning() {
            return this.isUserAgent("Lightning/1.0b2");
        }

        protected boolean isLightning() {
            return this.isUserAgent("Lightning/");
        }

        protected boolean isIcal5() {
            return this.isUserAgent("CoreDAV/") || this.isUserAgent("iOS/") || this.isUserAgent("Mac OS X/10.8");
        }

        protected boolean isUserAgent(String key) {
            String userAgent = this.headers.get("user-agent");
            return userAgent != null && userAgent.indexOf(key) >= 0;
        }

        public boolean isFreeBusy() {
            return this.body != null && this.body.indexOf("VFREEBUSY") >= 0;
        }

        protected void buildDepth() {
            String depthValue = this.headers.get("depth");
            if ("infinity".equalsIgnoreCase(depthValue)) {
                this.depth = Integer.MAX_VALUE;
            } else if (depthValue != null) {
                try {
                    this.depth = Integer.valueOf(depthValue);
                }
                catch (NumberFormatException e) {
                    DavGatewayTray.warn(new BundleMessage("LOG_INVALID_DEPTH", depthValue));
                }
            }
        }

        public int getDepth() {
            return this.depth;
        }

        public String getBody() {
            return this.body;
        }

        public String getHeader(String headerName) {
            return this.headers.get(headerName);
        }

        protected void parseXmlBody() throws IOException {
            if (this.body == null) {
                throw new DavMailException("EXCEPTION_INVALID_CALDAV_REQUEST", "Missing body");
            }
            XMLStreamReader streamReader = null;
            try {
                streamReader = XMLStreamUtil.createXMLStreamReader(this.body);
                while (streamReader.hasNext()) {
                    streamReader.next();
                    if (!XMLStreamUtil.isStartTag(streamReader)) continue;
                    String tagLocalName = streamReader.getLocalName();
                    if ("prop".equals(tagLocalName)) {
                        this.handleProp(streamReader);
                        continue;
                    }
                    if ("calendar-multiget".equals(tagLocalName) || "addressbook-multiget".equals(tagLocalName)) {
                        this.isMultiGet = true;
                        continue;
                    }
                    if ("comp-filter".equals(tagLocalName)) {
                        this.handleCompFilter(streamReader);
                        continue;
                    }
                    if (!"href".equals(tagLocalName)) continue;
                    if (this.hrefs == null) {
                        this.hrefs = new HashSet();
                    }
                    if (this.isBrokenHrefEncoding()) {
                        this.hrefs.add(streamReader.getElementText());
                        continue;
                    }
                    this.hrefs.add(URIUtil.decode((String)StringUtil.encodePlusSign(streamReader.getElementText())));
                }
            }
            catch (XMLStreamException e) {
                throw new DavMailException("EXCEPTION_INVALID_CALDAV_REQUEST", e.getMessage());
            }
            finally {
                try {
                    if (streamReader != null) {
                        streamReader.close();
                    }
                }
                catch (XMLStreamException e) {
                    DavGatewayTray.error(e);
                }
            }
        }

        protected boolean isEndTag(XMLStreamReader reader, String tagLocalName) {
            return reader.getEventType() == 2 && reader.getLocalName().equals(tagLocalName);
        }

        public void handleCompFilter(XMLStreamReader reader) throws XMLStreamException {
            while (reader.hasNext() && !this.isEndTag(reader, "comp-filter")) {
                reader.next();
                if (XMLStreamUtil.isStartTag(reader, "comp-filter")) {
                    String name = reader.getAttributeValue(null, "name");
                    if ("VEVENT".equals(name)) {
                        this.vEventOnly = true;
                        continue;
                    }
                    if (!"VTODO".equals(name)) continue;
                    this.vTodoOnly = true;
                    continue;
                }
                if (!XMLStreamUtil.isStartTag(reader, "time-range")) continue;
                this.timeRangeStart = reader.getAttributeValue(null, "start");
                this.timeRangeEnd = reader.getAttributeValue(null, "end");
            }
        }

        public void handleProp(XMLStreamReader reader) throws XMLStreamException {
            while (reader.hasNext() && !this.isEndTag(reader, "prop")) {
                reader.next();
                if (!XMLStreamUtil.isStartTag(reader)) continue;
                String tagLocalName = reader.getLocalName();
                String tagText = null;
                if ("displayname".equals(tagLocalName) || reader.hasText()) {
                    tagText = XMLStreamUtil.getElementText(reader);
                }
                this.properties.put(tagLocalName, tagText);
            }
        }

        public boolean hasProperty(String propertyName) {
            return this.properties.containsKey(propertyName);
        }

        public String getProperty(String propertyName) {
            return this.properties.get(propertyName);
        }

        public boolean isMultiGet() {
            return this.isMultiGet && this.hrefs != null;
        }

        public Set<String> getHrefs() {
            return this.hrefs;
        }

        public String toString() {
            return this.command + ' ' + this.path + " Depth: " + this.depth + '\n' + this.body;
        }

        public String getFolderPath() {
            return this.getFolderPath(null);
        }

        public String getParentFolderPath() {
            int endIndex = this.isFolder() ? this.getPathLength() - 1 : this.getPathLength() - 2;
            return this.getFolderPath(endIndex, null);
        }

        public String getFolderPath(String subFolder) {
            int endIndex = this.isFolder() ? this.getPathLength() : this.getPathLength() - 1;
            return this.getFolderPath(endIndex, subFolder);
        }

        protected String getFolderPath(int endIndex, String subFolder) {
            StringBuilder calendarPath = new StringBuilder();
            for (int i = 0; i < endIndex; ++i) {
                if (this.getPathElement(i).length() <= 0) continue;
                calendarPath.append('/').append(this.getPathElement(i));
            }
            if (subFolder != null && subFolder.length() > 0) {
                calendarPath.append('/').append(subFolder);
            }
            if (this.isUserAgent("Address%20Book") || this.isUserAgent("Darwin")) {
                String result = calendarPath.toString();
                if (result.indexOf(32) >= 0) {
                    result = result.replaceAll("___", " ");
                }
                if (result.startsWith("/public")) {
                    result = result.replaceAll("/addressbook", "");
                }
                return result;
            }
            return calendarPath.toString();
        }
    }
}

