/*
 * Decompiled with CFR 0.152.
 */
package davmail.exchange;

import davmail.Settings;
import davmail.exchange.ExchangeSession;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;
import javax.mail.MessagingException;
import org.apache.log4j.Logger;

public class MessageLoadThread
extends Thread {
    private static final Logger LOGGER = Logger.getLogger(MessageLoadThread.class);
    protected boolean isComplete = false;
    protected ExchangeSession.Message message;
    protected IOException ioException;
    protected MessagingException messagingException;

    protected MessageLoadThread(String threadName, ExchangeSession.Message message) {
        super(threadName + "-LoadMessage");
        this.setDaemon(true);
        this.message = message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.message.loadMimeMessage();
        }
        catch (IOException e) {
            this.ioException = e;
        }
        catch (MessagingException e) {
            this.messagingException = e;
        }
        finally {
            this.isComplete = true;
        }
    }

    public static void loadMimeMessage(ExchangeSession.Message message, OutputStream outputStream) throws IOException, MessagingException {
        if (message.size < 0x100000) {
            message.loadMimeMessage();
        } else {
            LOGGER.debug((Object)("Load large message " + message.size / 1024 + "KB uid " + message.getUid() + " imapUid " + message.getImapUid() + " in a separate thread"));
            try {
                MessageLoadThread messageLoadThread = new MessageLoadThread(MessageLoadThread.currentThread().getName(), message);
                messageLoadThread.start();
                while (!messageLoadThread.isComplete) {
                    messageLoadThread.join(10000L);
                    LOGGER.debug((Object)("Still loading uid " + message.getUid() + " imapUid " + message.getImapUid()));
                    if (!Settings.getBooleanProperty("davmail.enableKeepAlive", false)) continue;
                    try {
                        outputStream.write(32);
                        outputStream.flush();
                    }
                    catch (SocketException e) {
                        message.dropMimeMessage();
                        messageLoadThread.interrupt();
                        throw e;
                    }
                }
                if (messageLoadThread.ioException != null) {
                    throw messageLoadThread.ioException;
                }
                if (messageLoadThread.messagingException != null) {
                    throw messageLoadThread.messagingException;
                }
            }
            catch (InterruptedException e) {
                throw new IOException(e + " " + e.getMessage());
            }
        }
    }
}

