/*
 * Decompiled with CFR 0.152.
 */
package davmail.exchange;

import davmail.exchange.ICSBufferedReader;
import davmail.exchange.ICSBufferedWriter;
import davmail.exchange.VProperty;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VObject {
    ArrayList<VProperty> properties;
    ArrayList<VObject> vObjects;
    public String type;

    public VObject(VProperty beginProperty, BufferedReader reader) throws IOException {
        if (!"BEGIN".equals(beginProperty.getKey())) {
            throw new IOException("Invalid first line: " + beginProperty);
        }
        this.type = beginProperty.getValue();
        String beginLine = "BEGIN:" + this.type;
        String endLine = "END:" + this.type;
        String line = reader.readLine();
        while (line != null && !line.startsWith(endLine)) {
            if (!beginLine.equals(line)) {
                this.handleLine(line, reader);
            }
            line = reader.readLine();
        }
        if (line == null) {
            throw new IOException("Unexpected end of stream");
        }
    }

    public VObject(BufferedReader reader) throws IOException {
        this(new VProperty(reader.readLine()), reader);
    }

    public VObject(String itemBody) throws IOException {
        this(new ICSBufferedReader(new StringReader(itemBody)));
    }

    public VObject() {
    }

    protected void handleLine(String line, BufferedReader reader) throws IOException {
        if (line.length() > 0) {
            VProperty property = new VProperty(line);
            if ("BEGIN".equals(property.getKey())) {
                this.addVObject(new VObject(property, reader));
            } else if (property.getKey() != null) {
                this.addProperty(property);
            }
        }
    }

    public void addVObject(VObject vObject) {
        if (this.vObjects == null) {
            this.vObjects = new ArrayList();
        }
        this.vObjects.add(vObject);
    }

    public void addProperty(VProperty property) {
        if (property.getValue() != null) {
            if (this.properties == null) {
                this.properties = new ArrayList();
            }
            this.properties.add(property);
        }
    }

    public void writeTo(ICSBufferedWriter writer) {
        writer.write("BEGIN:");
        writer.writeLine(this.type);
        if (this.properties != null) {
            for (VProperty property : this.properties) {
                writer.writeLine(property.toString());
            }
        }
        if (this.vObjects != null) {
            for (VObject object : this.vObjects) {
                object.writeTo(writer);
            }
        }
        writer.write("END:");
        writer.writeLine(this.type);
    }

    public String toString() {
        ICSBufferedWriter writer = new ICSBufferedWriter();
        this.writeTo(writer);
        return writer.toString();
    }

    public List<VProperty> getProperties() {
        return this.properties;
    }

    public VProperty getProperty(String name) {
        if (this.properties != null) {
            for (VProperty property : this.properties) {
                if (property.getKey() == null || !property.getKey().equalsIgnoreCase(name)) continue;
                return property;
            }
        }
        return null;
    }

    public List<VProperty> getProperties(String name) {
        ArrayList<VProperty> result = null;
        if (this.properties != null) {
            for (VProperty property : this.properties) {
                if (property.getKey() == null || !property.getKey().equalsIgnoreCase(name)) continue;
                if (result == null) {
                    result = new ArrayList<VProperty>();
                }
                result.add(property);
            }
        }
        return result;
    }

    public String getPropertyValue(String name) {
        VProperty property = this.getProperty(name);
        if (property != null) {
            return property.getValue();
        }
        return null;
    }

    public void setPropertyValue(String name, String value) {
        if (value == null) {
            this.removeProperty(name);
        } else {
            VProperty property = this.getProperty(name);
            if (property == null) {
                property = new VProperty(name, value);
                this.addProperty(property);
            } else {
                property.setValue(value);
            }
        }
    }

    public void addPropertyValue(String name, String value) {
        if (value != null) {
            VProperty property = new VProperty(name, value);
            this.addProperty(property);
        }
    }

    public void removeProperty(String name) {
        VProperty property;
        if (this.properties != null && (property = this.getProperty(name)) != null) {
            this.properties.remove(property);
        }
    }

    public void removeProperty(VProperty property) {
        if (this.properties != null) {
            this.properties.remove(property);
        }
    }
}

