/*
 * Decompiled with CFR 0.152.
 */
package davmail.exchange.dav;

import davmail.exchange.dav.ExchangeDavMethod;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;
import org.apache.jackrabbit.webdav.header.DepthHeader;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameIterator;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.log4j.Logger;

public class ExchangePropFindMethod
extends ExchangeDavMethod {
    protected static final Logger LOGGER = Logger.getLogger(ExchangePropFindMethod.class);
    protected final DavPropertyNameSet propertyNameSet;

    public ExchangePropFindMethod(String uri) {
        this(uri, null, Integer.MAX_VALUE);
    }

    public ExchangePropFindMethod(String uri, DavPropertyNameSet propertyNameSet, int depth) {
        super(uri);
        this.propertyNameSet = propertyNameSet;
        DepthHeader dh = new DepthHeader(depth);
        this.setRequestHeader(dh.getHeaderName(), dh.getHeaderValue());
    }

    protected byte[] generateRequestContent() {
        try {
            int currentChar = 101;
            HashMap<String, Integer> nameSpaceMap = new HashMap<String, Integer>();
            nameSpaceMap.put("DAV:", 68);
            if (this.propertyNameSet != null) {
                DavPropertyNameIterator propertyNameIterator = this.propertyNameSet.iterator();
                while (propertyNameIterator.hasNext()) {
                    DavPropertyName davPropertyName = propertyNameIterator.nextPropertyName();
                    davPropertyName.getName();
                    String namespaceUri = davPropertyName.getNamespace().getURI();
                    if (nameSpaceMap.containsKey(namespaceUri)) continue;
                    nameSpaceMap.put(namespaceUri, currentChar++);
                }
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baos, "UTF-8");
            writer.write("<D:propfind ");
            for (Map.Entry mapEntry : nameSpaceMap.entrySet()) {
                writer.write(" xmlns:");
                writer.write((char)((Integer)mapEntry.getValue()).intValue());
                writer.write("=\"");
                writer.write((String)mapEntry.getKey());
                writer.write("\"");
            }
            writer.write(">");
            if (this.propertyNameSet == null || this.propertyNameSet.isEmpty()) {
                writer.write("<D:allprop/>");
            } else {
                writer.write("<D:prop>");
                DavPropertyNameIterator propertyNameIterator = this.propertyNameSet.iterator();
                while (propertyNameIterator.hasNext()) {
                    DavPropertyName davPropertyName = propertyNameIterator.nextPropertyName();
                    char nameSpaceChar = (char)((Integer)nameSpaceMap.get(davPropertyName.getNamespace().getURI())).intValue();
                    writer.write(60);
                    writer.write(nameSpaceChar);
                    writer.write(58);
                    writer.write(davPropertyName.getName());
                    writer.write("/>");
                }
                writer.write("</D:prop>");
            }
            writer.write("</D:propfind>");
            writer.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getName() {
        return "PROPFIND";
    }
}

