/*
 * Decompiled with CFR 0.152.
 */
package davmail.exchange.dav;

import davmail.exchange.dav.ExchangeDavMethod;
import davmail.util.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.log4j.Logger;

public class ExchangeSearchMethod
extends ExchangeDavMethod {
    protected static final Logger LOGGER = Logger.getLogger(ExchangeSearchMethod.class);
    protected final String searchRequest;

    public ExchangeSearchMethod(String uri, String searchRequest) {
        super(uri);
        this.searchRequest = searchRequest;
    }

    protected byte[] generateRequestContent() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baos, "UTF-8");
            writer.write("<?xml version=\"1.0\"?>\n");
            writer.write("<d:searchrequest xmlns:d=\"DAV:\">\n");
            writer.write("        <d:sql>");
            writer.write(StringUtil.xmlEncode(this.searchRequest));
            writer.write("</d:sql>\n");
            writer.write("</d:searchrequest>");
            writer.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getName() {
        return "SEARCH";
    }
}

