/*
 * Decompiled with CFR 0.152.
 */
package davmail.exchange.ews;

import davmail.Settings;
import davmail.exception.DavMailAuthenticationException;
import davmail.exception.DavMailException;
import davmail.exception.HttpNotFoundException;
import davmail.exchange.ExchangeSession;
import davmail.exchange.VCalendar;
import davmail.exchange.VObject;
import davmail.exchange.VProperty;
import davmail.exchange.ews.BaseShape;
import davmail.exchange.ews.ConflictResolution;
import davmail.exchange.ews.ContainmentComparison;
import davmail.exchange.ews.ContainmentMode;
import davmail.exchange.ews.CopyItemMethod;
import davmail.exchange.ews.CreateAttachmentMethod;
import davmail.exchange.ews.CreateFolderMethod;
import davmail.exchange.ews.CreateItemMethod;
import davmail.exchange.ews.DeleteAttachmentMethod;
import davmail.exchange.ews.DeleteFolderMethod;
import davmail.exchange.ews.DeleteItemMethod;
import davmail.exchange.ews.DeleteType;
import davmail.exchange.ews.DistinguishedFolderId;
import davmail.exchange.ews.EWSException;
import davmail.exchange.ews.EWSMethod;
import davmail.exchange.ews.ExtendedFieldURI;
import davmail.exchange.ews.Field;
import davmail.exchange.ews.FieldOrder;
import davmail.exchange.ews.FieldURI;
import davmail.exchange.ews.FieldUpdate;
import davmail.exchange.ews.FileAttachment;
import davmail.exchange.ews.FindFolderMethod;
import davmail.exchange.ews.FindItemMethod;
import davmail.exchange.ews.FolderId;
import davmail.exchange.ews.FolderQueryTraversal;
import davmail.exchange.ews.GetAttachmentMethod;
import davmail.exchange.ews.GetFolderMethod;
import davmail.exchange.ews.GetItemMethod;
import davmail.exchange.ews.GetUserAvailabilityMethod;
import davmail.exchange.ews.GetUserConfigurationMethod;
import davmail.exchange.ews.IndexedFieldUpdate;
import davmail.exchange.ews.ItemId;
import davmail.exchange.ews.MessageDisposition;
import davmail.exchange.ews.MoveFolderMethod;
import davmail.exchange.ews.MoveItemMethod;
import davmail.exchange.ews.ResolveNamesMethod;
import davmail.exchange.ews.SearchExpression;
import davmail.exchange.ews.SendMeetingCancellations;
import davmail.exchange.ews.SendMeetingInvitations;
import davmail.exchange.ews.SendMeetingInvitationsOrCancellations;
import davmail.exchange.ews.TwoOperandExpression;
import davmail.exchange.ews.UpdateFolderMethod;
import davmail.exchange.ews.UpdateItemMethod;
import davmail.http.DavGatewayHttpClientFacade;
import davmail.util.IOUtil;
import davmail.util.StringUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.util.SharedByteArrayInputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EwsExchangeSession
extends ExchangeSession {
    protected static final int PAGE_SIZE = 500;
    protected static final String ARCHIVE_ROOT = "/archive/";
    protected static final Set<String> MESSAGE_TYPES = new HashSet<String>();
    static final Map<String, String> vTodoToTaskStatusMap;
    static final Map<String, String> taskTovTodoStatusMap;
    protected Map<String, String> folderIdMap;
    protected boolean directEws;
    protected static final HashSet<FieldURI> FOLDER_PROPERTIES;
    protected static final Set<String> ITEM_PROPERTIES;
    protected static final HashSet<String> EVENT_REQUEST_PROPERTIES;
    protected static final String USERS_ROOT = "/users/";
    protected static final HashMap<String, String> GALFIND_ATTRIBUTE_MAP;
    protected static final HashSet<String> IGNORE_ATTRIBUTE_SET;
    protected static final Map<String, String> importanceToPriorityMap;
    protected static final Map<String, String> priorityToImportanceMap;

    public EwsExchangeSession(String url, String userName, String password) throws IOException {
        super(url, userName, password);
    }

    @Override
    protected boolean isBasicAuthentication(HttpClient httpClient, String url) {
        return !url.toLowerCase().endsWith("/ews/exchange.asmx") && super.isBasicAuthentication(httpClient, url);
    }

    @Override
    protected HttpMethod formLogin(HttpClient httpClient, HttpMethod initmethod, String userName, String password) throws IOException {
        LOGGER.debug((Object)"Form based authentication detected");
        HttpMethod logonMethod = this.buildLogonMethod(httpClient, initmethod);
        if (logonMethod == null) {
            LOGGER.debug((Object)("Authentication form not found at " + initmethod.getURI() + ", will try direct EWS access"));
        } else {
            logonMethod = this.postLogonMethod(httpClient, logonMethod, userName, password);
        }
        return logonMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkEndPointUrl(String endPointUrl) throws IOException {
        GetFolderMethod checkMethod = new GetFolderMethod(BaseShape.ID_ONLY, DistinguishedFolderId.getInstance(null, DistinguishedFolderId.Name.root), null);
        try {
            int status = DavGatewayHttpClientFacade.executeNoRedirect(this.httpClient, (HttpMethod)checkMethod);
            if (status == 401) {
                checkMethod.releaseConnection();
                checkMethod = new GetFolderMethod(BaseShape.ID_ONLY, DistinguishedFolderId.getInstance(null, DistinguishedFolderId.Name.root), null);
                status = DavGatewayHttpClientFacade.executeNoRedirect(this.httpClient, (HttpMethod)checkMethod);
                if (status == 401) {
                    throw new DavMailAuthenticationException("EXCEPTION_AUTHENTICATION_FAILED");
                }
                if (status != 200) {
                    throw new IOException("Ews endpoint not available at " + checkMethod.getURI().toString() + " status " + status);
                }
            } else if (status != 200) {
                throw new IOException("Ews endpoint not available at " + checkMethod.getURI().toString() + " status " + status);
            }
        }
        finally {
            checkMethod.releaseConnection();
        }
    }

    @Override
    protected void buildSessionInfo(HttpMethod method) throws DavMailException {
        if (method != null) {
            method.releaseConnection();
        }
        boolean bl = this.directEws = method == null || "/ews/services.wsdl".equalsIgnoreCase(method.getPath()) || "/ews/exchange.asmx".equalsIgnoreCase(method.getPath());
        if (!this.directEws) {
            this.getEmailAndAliasFromOptions();
        }
        if (this.email == null || this.alias == null) {
            if (this.userName.indexOf(64) >= 0) {
                this.email = this.userName;
                this.alias = this.userName.substring(0, this.userName.indexOf(64));
            } else {
                this.alias = this.getAliasFromLogin();
                this.resolveEmailAddress(this.userName);
                if (this.email == null) {
                    this.email = this.getAliasFromLogin() + this.getEmailSuffixFromHostname();
                }
            }
        }
        this.currentMailboxPath = USERS_ROOT + this.email.toLowerCase();
        try {
            this.checkEndPointUrl("/ews/exchange.asmx");
            this.internalGetFolder("");
        }
        catch (IOException e) {
            DavGatewayHttpClientFacade.addNTLM(this.httpClient);
            try {
                this.checkEndPointUrl("/ews/exchange.asmx");
                this.internalGetFolder("");
            }
            catch (IOException e2) {
                LOGGER.debug((Object)e2.getMessage());
                try {
                    this.checkEndPointUrl(this.getEwsUrlFromAutoDiscover());
                    this.internalGetFolder("");
                }
                catch (IOException e3) {
                    if (e instanceof DavMailAuthenticationException) {
                        throw (DavMailAuthenticationException)e;
                    }
                    LOGGER.error((Object)e2.getMessage());
                    throw new DavMailAuthenticationException("EXCEPTION_EWS_NOT_AVAILABLE");
                }
            }
        }
        if (!DavGatewayHttpClientFacade.hasNTLMorNegotiate(this.httpClient)) {
            this.httpClient.getParams().setParameter("http.authentication.preemptive", (Object)true);
        }
        if (this.directEws) {
            try {
                ResolveNamesMethod resolveNamesMethod = new ResolveNamesMethod(this.alias);
                this.executeMethod(resolveNamesMethod);
                List<EWSMethod.Item> responses = resolveNamesMethod.getResponseItems();
                for (EWSMethod.Item response : responses) {
                    if (!this.alias.equalsIgnoreCase((String)response.get("Name"))) continue;
                    this.email = (String)response.get("EmailAddress");
                    this.currentMailboxPath = USERS_ROOT + this.email.toLowerCase();
                }
            }
            catch (IOException e) {
                LOGGER.warn((Object)"Unable to get primary email address with ResolveNames", (Throwable)e);
            }
        }
        try {
            this.folderIdMap = new HashMap<String, String>();
            this.folderIdMap.put(this.internalGetFolder((String)"INBOX").folderId.value, "INBOX");
            this.folderIdMap.put(this.internalGetFolder((String)"calendar").folderId.value, "calendar");
            this.folderIdMap.put(this.internalGetFolder((String)"contacts").folderId.value, "contacts");
            this.folderIdMap.put(this.internalGetFolder((String)"Sent").folderId.value, "Sent");
            this.folderIdMap.put(this.internalGetFolder((String)"Drafts").folderId.value, "Drafts");
            this.folderIdMap.put(this.internalGetFolder((String)"Trash").folderId.value, "Trash");
            this.folderIdMap.put(this.internalGetFolder((String)"Junk").folderId.value, "Junk");
            this.folderIdMap.put(this.internalGetFolder((String)"Unsent Messages").folderId.value, "Unsent Messages");
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new DavMailAuthenticationException("EXCEPTION_EWS_NOT_AVAILABLE");
        }
        LOGGER.debug((Object)("Current user email is " + this.email + ", alias is " + this.alias + " on " + this.serverVersion));
    }

    protected void resolveEmailAddress(String userName) {
        String searchValue = userName;
        int index = searchValue.indexOf(92);
        if (index >= 0) {
            searchValue = searchValue.substring(index + 1);
        }
        ResolveNamesMethod resolveNamesMethod = new ResolveNamesMethod(searchValue);
        try {
            this.internalGetFolder("");
            this.executeMethod(resolveNamesMethod);
            List<EWSMethod.Item> responses = resolveNamesMethod.getResponseItems();
            if (responses.size() == 1) {
                this.email = (String)responses.get(0).get("EmailAddress");
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    protected String getEwsUrlFromAutoDiscover() throws DavMailAuthenticationException {
        String ewsUrl;
        try {
            ewsUrl = this.getEwsUrlFromAutoDiscover(null);
        }
        catch (IOException e) {
            try {
                ewsUrl = this.getEwsUrlFromAutoDiscover("autodiscover." + this.email.substring(this.email.indexOf(64) + 1));
            }
            catch (IOException e2) {
                LOGGER.error((Object)e2.getMessage());
                throw new DavMailAuthenticationException("EXCEPTION_EWS_NOT_AVAILABLE");
            }
        }
        return ewsUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getEwsUrlFromAutoDiscover(String autodiscoverHostname) throws IOException {
        String ewsUrl;
        AutoDiscoverMethod autoDiscoverMethod = autodiscoverHostname != null ? new AutoDiscoverMethod(autodiscoverHostname, this.email) : new AutoDiscoverMethod(this.email);
        try {
            int status = DavGatewayHttpClientFacade.executeNoRedirect(this.httpClient, (HttpMethod)autoDiscoverMethod);
            if (status != 200) {
                throw DavGatewayHttpClientFacade.buildHttpException((HttpMethod)autoDiscoverMethod);
            }
            ewsUrl = autoDiscoverMethod.ewsUrl;
            DavGatewayHttpClientFacade.setClientHost(this.httpClient, ewsUrl);
            if (ewsUrl == null) {
                throw new IOException("Ews url not found");
            }
        }
        finally {
            autoDiscoverMethod.releaseConnection();
        }
        return ewsUrl;
    }

    protected List<FieldUpdate> buildProperties(Map<String, String> properties) {
        ArrayList<FieldUpdate> list = new ArrayList<FieldUpdate>();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            if ("read".equals(entry.getKey())) {
                list.add(Field.createFieldUpdate("read", Boolean.toString("1".equals(entry.getValue()))));
                continue;
            }
            if ("junk".equals(entry.getKey())) {
                list.add(Field.createFieldUpdate("junk", entry.getValue()));
                continue;
            }
            if ("flagged".equals(entry.getKey())) {
                list.add(Field.createFieldUpdate("flagStatus", entry.getValue()));
                continue;
            }
            if ("answered".equals(entry.getKey())) {
                list.add(Field.createFieldUpdate("lastVerbExecuted", entry.getValue()));
                if (!"102".equals(entry.getValue())) continue;
                list.add(Field.createFieldUpdate("iconIndex", "261"));
                continue;
            }
            if ("forwarded".equals(entry.getKey())) {
                list.add(Field.createFieldUpdate("lastVerbExecuted", entry.getValue()));
                if (!"104".equals(entry.getValue())) continue;
                list.add(Field.createFieldUpdate("iconIndex", "262"));
                continue;
            }
            if ("draft".equals(entry.getKey())) {
                list.add(Field.createFieldUpdate("messageFlags", entry.getValue()));
                continue;
            }
            if ("deleted".equals(entry.getKey())) {
                list.add(Field.createFieldUpdate("deleted", entry.getValue()));
                continue;
            }
            if ("datereceived".equals(entry.getKey())) {
                list.add(Field.createFieldUpdate("datereceived", entry.getValue()));
                continue;
            }
            if (!"keywords".equals(entry.getKey())) continue;
            list.add(Field.createFieldUpdate("keywords", entry.getValue()));
        }
        return list;
    }

    @Override
    public void createMessage(String folderPath, String messageName, HashMap<String, String> properties, MimeMessage mimeMessage) throws IOException {
        EWSMethod.Item item = new EWSMethod.Item();
        item.type = "Message";
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            mimeMessage.writeTo((OutputStream)baos);
        }
        catch (MessagingException e) {
            throw new IOException(e.getMessage());
        }
        baos.close();
        item.mimeContent = IOUtil.encodeBase64(baos.toByteArray());
        List<FieldUpdate> fieldUpdates = this.buildProperties(properties);
        if (!properties.containsKey("draft")) {
            if (properties.containsKey("read")) {
                fieldUpdates.add(Field.createFieldUpdate("messageFlags", "1"));
            } else {
                fieldUpdates.add(Field.createFieldUpdate("messageFlags", "0"));
            }
        }
        fieldUpdates.add(Field.createFieldUpdate("urlcompname", messageName));
        item.setFieldUpdates(fieldUpdates);
        CreateItemMethod createItemMethod = new CreateItemMethod(MessageDisposition.SaveOnly, this.getFolderId(folderPath), item);
        this.executeMethod(createItemMethod);
    }

    @Override
    public void updateMessage(ExchangeSession.Message message, Map<String, String> properties) throws IOException {
        if (properties.containsKey("read") && "urn:content-classes:appointment".equals(message.contentClass)) {
            properties.remove("read");
        }
        if (!properties.isEmpty()) {
            UpdateItemMethod updateItemMethod = new UpdateItemMethod(MessageDisposition.SaveOnly, ConflictResolution.AlwaysOverwrite, SendMeetingInvitationsOrCancellations.SendToNone, ((Message)message).itemId, this.buildProperties(properties));
            this.executeMethod(updateItemMethod);
        }
    }

    @Override
    public void deleteMessage(ExchangeSession.Message message) throws IOException {
        LOGGER.debug((Object)("Delete " + message.imapUid));
        DeleteItemMethod deleteItemMethod = new DeleteItemMethod(((Message)message).itemId, DeleteType.HardDelete, SendMeetingCancellations.SendToNone);
        this.executeMethod(deleteItemMethod);
    }

    protected void sendMessage(String itemClass, byte[] messageBody) throws IOException {
        EWSMethod.Item item = new EWSMethod.Item();
        item.type = "Message";
        item.mimeContent = IOUtil.encodeBase64(messageBody);
        if (itemClass != null) {
            item.put("ItemClass", itemClass);
        }
        MessageDisposition messageDisposition = Settings.getBooleanProperty("davmail.smtpSaveInSent", true) ? MessageDisposition.SendAndSaveCopy : MessageDisposition.SendOnly;
        CreateItemMethod createItemMethod = new CreateItemMethod(messageDisposition, this.getFolderId("Sent"), item);
        this.executeMethod(createItemMethod);
    }

    @Override
    public void sendMessage(MimeMessage mimeMessage) throws IOException, MessagingException {
        String itemClass = null;
        if (mimeMessage.getContentType().startsWith("multipart/report")) {
            itemClass = "REPORT.IPM.Note.IPNRN";
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            mimeMessage.writeTo((OutputStream)baos);
        }
        catch (MessagingException e) {
            throw new IOException(e.getMessage());
        }
        this.sendMessage(itemClass, baos.toByteArray());
    }

    @Override
    protected byte[] getContent(ExchangeSession.Message message) throws IOException {
        return this.getContent(((Message)message).itemId);
    }

    protected byte[] getContent(ItemId itemId) throws IOException {
        GetItemMethod getItemMethod = new GetItemMethod(BaseShape.ID_ONLY, itemId, true);
        byte[] mimeContent = null;
        try {
            this.executeMethod(getItemMethod);
            mimeContent = getItemMethod.getMimeContent();
        }
        catch (EWSException e) {
            LOGGER.warn((Object)("GetItem with MimeContent failed: " + e.getMessage()));
        }
        if (getItemMethod.getStatusCode() == 404) {
            throw new HttpNotFoundException("Item " + itemId + " not found");
        }
        if (mimeContent == null) {
            LOGGER.warn((Object)"MimeContent not available, trying to rebuild from properties");
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                getItemMethod = new GetItemMethod(BaseShape.ID_ONLY, itemId, false);
                getItemMethod.addAdditionalProperty(Field.get("contentclass"));
                getItemMethod.addAdditionalProperty(Field.get("message-id"));
                getItemMethod.addAdditionalProperty(Field.get("from"));
                getItemMethod.addAdditionalProperty(Field.get("to"));
                getItemMethod.addAdditionalProperty(Field.get("cc"));
                getItemMethod.addAdditionalProperty(Field.get("subject"));
                getItemMethod.addAdditionalProperty(Field.get("date"));
                getItemMethod.addAdditionalProperty(Field.get("body"));
                this.executeMethod(getItemMethod);
                EWSMethod.Item item = getItemMethod.getResponseItem();
                if (item == null) {
                    throw new HttpNotFoundException("Item " + itemId + " not found");
                }
                MimeMessage mimeMessage = new MimeMessage((Session)null);
                mimeMessage.addHeader("Content-class", (String)item.get(Field.get("contentclass").getResponseName()));
                mimeMessage.setSentDate(this.parseDateFromExchange((String)item.get(Field.get("date").getResponseName())));
                mimeMessage.addHeader("From", (String)item.get(Field.get("from").getResponseName()));
                mimeMessage.addHeader("To", (String)item.get(Field.get("to").getResponseName()));
                mimeMessage.addHeader("Cc", (String)item.get(Field.get("cc").getResponseName()));
                mimeMessage.setSubject((String)item.get(Field.get("subject").getResponseName()));
                String propertyValue = (String)item.get(Field.get("body").getResponseName());
                if (propertyValue == null) {
                    propertyValue = "";
                }
                mimeMessage.setContent((Object)propertyValue, "text/html; charset=UTF-8");
                mimeMessage.writeTo((OutputStream)baos);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Rebuilt message content: " + new String(baos.toByteArray(), "UTF-8")));
                }
                mimeContent = baos.toByteArray();
            }
            catch (IOException e2) {
                LOGGER.warn((Object)e2);
            }
            catch (MessagingException e2) {
                LOGGER.warn((Object)e2);
            }
            if (mimeContent == null) {
                throw new IOException("GetItem returned null MimeContent");
            }
        }
        return mimeContent;
    }

    protected Message buildMessage(EWSMethod.Item response) throws DavMailException {
        Message message = new Message();
        message.itemId = new ItemId(response);
        message.permanentUrl = (String)response.get(Field.get("permanenturl").getResponseName());
        message.size = response.getInt(Field.get("messageSize").getResponseName());
        message.uid = (String)response.get(Field.get("uid").getResponseName());
        message.contentClass = (String)response.get(Field.get("contentclass").getResponseName());
        message.imapUid = response.getLong(Field.get("imapUid").getResponseName());
        message.read = response.getBoolean(Field.get("read").getResponseName());
        message.junk = response.getBoolean(Field.get("junk").getResponseName());
        message.flagged = "2".equals(response.get(Field.get("flagStatus").getResponseName()));
        message.draft = (response.getInt(Field.get("messageFlags").getResponseName()) & 8) != 0;
        String lastVerbExecuted = (String)response.get(Field.get("lastVerbExecuted").getResponseName());
        message.answered = "102".equals(lastVerbExecuted) || "103".equals(lastVerbExecuted);
        message.forwarded = "104".equals(lastVerbExecuted);
        message.date = this.convertDateFromExchange((String)response.get(Field.get("date").getResponseName()));
        message.deleted = "1".equals(response.get(Field.get("deleted").getResponseName()));
        String lastmodified = this.convertDateFromExchange((String)response.get(Field.get("lastmodified").getResponseName()));
        message.recent = !message.read && lastmodified != null && lastmodified.equals(message.date);
        message.keywords = (String)response.get(Field.get("keywords").getResponseName());
        if (LOGGER.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Message");
            if (message.imapUid != 0L) {
                buffer.append(" IMAP uid: ").append(message.imapUid);
            }
            if (message.uid != null) {
                buffer.append(" uid: ").append(message.uid);
            }
            buffer.append(" ItemId: ").append(message.itemId.id);
            buffer.append(" ChangeKey: ").append(message.itemId.changeKey);
            LOGGER.debug((Object)buffer.toString());
        }
        return message;
    }

    @Override
    public ExchangeSession.MessageList searchMessages(String folderPath, Set<String> attributes, ExchangeSession.Condition condition) throws IOException {
        ExchangeSession.MessageList messages = new ExchangeSession.MessageList();
        int maxCount = Settings.getIntProperty("davmail.folderSizeLimit", 0);
        List<EWSMethod.Item> responses = this.searchItems(folderPath, attributes, condition, FolderQueryTraversal.SHALLOW, maxCount);
        for (EWSMethod.Item response : responses) {
            if (!MESSAGE_TYPES.contains(response.type)) continue;
            Message message = this.buildMessage(response);
            message.messageList = messages;
            messages.add(message);
        }
        Collections.sort(messages);
        return messages;
    }

    protected List<EWSMethod.Item> searchItems(String folderPath, Set<String> attributes, ExchangeSession.Condition condition, FolderQueryTraversal folderQueryTraversal, int maxCount) throws IOException {
        if (maxCount == 0) {
            return this.searchItems(folderPath, attributes, condition, folderQueryTraversal);
        }
        ArrayList<EWSMethod.Item> results = new ArrayList<EWSMethod.Item>();
        FindItemMethod findItemMethod = new FindItemMethod(folderQueryTraversal, BaseShape.ID_ONLY, this.getFolderId(folderPath), 0, maxCount);
        for (String attribute : attributes) {
            findItemMethod.addAdditionalProperty(Field.get(attribute));
        }
        if (!attributes.contains("imapUid")) {
            findItemMethod.addAdditionalProperty(Field.get("imapUid"));
        }
        findItemMethod.setFieldOrder(new FieldOrder(Field.get("imapUid"), FieldOrder.Order.Descending));
        if (condition != null && !condition.isEmpty()) {
            findItemMethod.setSearchExpression((SearchExpression)((Object)condition));
        }
        this.executeMethod(findItemMethod);
        results.addAll(findItemMethod.getResponseItems());
        int resultCount = results.size();
        if (resultCount > 0 && LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Folder " + folderPath + " - Search items count: " + resultCount + " maxCount: " + maxCount + " highest uid: " + (String)((EWSMethod.Item)results.get(0)).get(Field.get("imapUid").getResponseName()) + " lowest uid: " + (String)((EWSMethod.Item)results.get(resultCount - 1)).get(Field.get("imapUid").getResponseName())));
        }
        return results;
    }

    protected List<EWSMethod.Item> searchItems(String folderPath, Set<String> attributes, ExchangeSession.Condition condition, FolderQueryTraversal folderQueryTraversal) throws IOException {
        FindItemMethod findItemMethod;
        int resultCount = 0;
        ArrayList<EWSMethod.Item> results = new ArrayList<EWSMethod.Item>();
        FolderId folderId = this.getFolderId(folderPath);
        do {
            findItemMethod = new FindItemMethod(folderQueryTraversal, BaseShape.ID_ONLY, folderId, resultCount, 500);
            for (String attribute : attributes) {
                findItemMethod.addAdditionalProperty(Field.get(attribute));
            }
            if (!attributes.contains("imapUid")) {
                findItemMethod.addAdditionalProperty(Field.get("imapUid"));
            }
            findItemMethod.setFieldOrder(new FieldOrder(Field.get("imapUid"), FieldOrder.Order.Ascending));
            if (condition != null && !condition.isEmpty()) {
                findItemMethod.setSearchExpression((SearchExpression)((Object)condition));
            }
            this.executeMethod(findItemMethod);
            long highestUid = 0L;
            if (resultCount > 0) {
                highestUid = Long.parseLong((String)((EWSMethod.Item)results.get(resultCount - 1)).get(Field.get("imapUid").getResponseName()));
            }
            for (EWSMethod.Item item : findItemMethod.getResponseItems()) {
                long imapUid = Long.parseLong((String)item.get(Field.get("imapUid").getResponseName()));
                if (imapUid <= highestUid) continue;
                results.add(item);
            }
            resultCount = results.size();
            if (resultCount > 0 && LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Folder " + folderPath + " - Search items current count: " + resultCount + " fetchCount: " + 500 + " highest uid: " + (String)((EWSMethod.Item)results.get(resultCount - 1)).get(Field.get("imapUid").getResponseName()) + " lowest uid: " + (String)((EWSMethod.Item)results.get(0)).get(Field.get("imapUid").getResponseName())));
            }
            if (!Thread.interrupted()) continue;
            LOGGER.debug((Object)("Folder " + folderPath + " - Search items failed: Interrupted by client"));
            throw new IOException("Search items failed: Interrupted by client");
        } while (!findItemMethod.includesLastItemInRange);
        return results;
    }

    @Override
    public ExchangeSession.MultiCondition and(ExchangeSession.Condition ... condition) {
        return new MultiCondition(ExchangeSession.Operator.And, condition);
    }

    @Override
    public ExchangeSession.MultiCondition or(ExchangeSession.Condition ... condition) {
        return new MultiCondition(ExchangeSession.Operator.Or, condition);
    }

    @Override
    public ExchangeSession.Condition not(ExchangeSession.Condition condition) {
        return new NotCondition(condition);
    }

    @Override
    public ExchangeSession.Condition isEqualTo(String attributeName, String value) {
        return new AttributeCondition(attributeName, ExchangeSession.Operator.IsEqualTo, value);
    }

    @Override
    public ExchangeSession.Condition isEqualTo(String attributeName, int value) {
        return new AttributeCondition(attributeName, ExchangeSession.Operator.IsEqualTo, String.valueOf(value));
    }

    @Override
    public ExchangeSession.Condition headerIsEqualTo(String headerName, String value) {
        if (this.serverVersion.startsWith("Exchange201")) {
            if ("from".equals(headerName) || "to".equals(headerName) || "cc".equals(headerName)) {
                return new AttributeCondition("msg" + headerName, ExchangeSession.Operator.Contains, value, ContainmentMode.Substring, ContainmentComparison.IgnoreCase);
            }
            if ("message-id".equals(headerName) || "bcc".equals(headerName)) {
                return new AttributeCondition(headerName, ExchangeSession.Operator.Contains, value, ContainmentMode.Substring, ContainmentComparison.IgnoreCase);
            }
            return new AttributeCondition("messageheaders", ExchangeSession.Operator.Contains, headerName + ": " + value, ContainmentMode.Substring, ContainmentComparison.IgnoreCase);
        }
        return new HeaderCondition(headerName, value);
    }

    @Override
    public ExchangeSession.Condition gte(String attributeName, String value) {
        return new AttributeCondition(attributeName, ExchangeSession.Operator.IsGreaterThanOrEqualTo, value);
    }

    @Override
    public ExchangeSession.Condition lte(String attributeName, String value) {
        return new AttributeCondition(attributeName, ExchangeSession.Operator.IsLessThanOrEqualTo, value);
    }

    @Override
    public ExchangeSession.Condition lt(String attributeName, String value) {
        return new AttributeCondition(attributeName, ExchangeSession.Operator.IsLessThan, value);
    }

    @Override
    public ExchangeSession.Condition gt(String attributeName, String value) {
        return new AttributeCondition(attributeName, ExchangeSession.Operator.IsGreaterThan, value);
    }

    @Override
    public ExchangeSession.Condition contains(String attributeName, String value) {
        return new AttributeCondition(attributeName, ExchangeSession.Operator.Contains, value, ContainmentMode.Substring, ContainmentComparison.IgnoreCase);
    }

    @Override
    public ExchangeSession.Condition startsWith(String attributeName, String value) {
        return new AttributeCondition(attributeName, ExchangeSession.Operator.Contains, value, ContainmentMode.Prefixed, ContainmentComparison.IgnoreCase);
    }

    @Override
    public ExchangeSession.Condition isNull(String attributeName) {
        return new IsNullCondition(attributeName);
    }

    @Override
    public ExchangeSession.Condition isTrue(String attributeName) {
        return new AttributeCondition(attributeName, ExchangeSession.Operator.IsEqualTo, "true");
    }

    @Override
    public ExchangeSession.Condition isFalse(String attributeName) {
        return new AttributeCondition(attributeName, ExchangeSession.Operator.IsEqualTo, "false");
    }

    protected Folder buildFolder(EWSMethod.Item item) {
        Folder folder = new Folder();
        folder.folderId = new FolderId(item);
        folder.displayName = (String)item.get(Field.get("folderDisplayName").getResponseName());
        folder.folderClass = (String)item.get(Field.get("folderclass").getResponseName());
        folder.etag = (String)item.get(Field.get("lastmodified").getResponseName());
        folder.ctag = (String)item.get(Field.get("ctag").getResponseName());
        folder.count = item.getInt(Field.get("count").getResponseName());
        folder.recent = folder.unreadCount = item.getInt(Field.get("unread").getResponseName());
        folder.hasChildren = item.getBoolean(Field.get("hassubs").getResponseName());
        folder.uidNext = item.getInt(Field.get("uidNext").getResponseName());
        return folder;
    }

    @Override
    public List<ExchangeSession.Folder> getSubFolders(String folderPath, ExchangeSession.Condition condition, boolean recursive) throws IOException {
        int index;
        String baseFolderPath = folderPath;
        if (baseFolderPath.startsWith(USERS_ROOT) && (index = baseFolderPath.indexOf(47, USERS_ROOT.length())) >= 0) {
            baseFolderPath = baseFolderPath.substring(index + 1);
        }
        ArrayList<ExchangeSession.Folder> folders = new ArrayList<ExchangeSession.Folder>();
        this.appendSubFolders(folders, baseFolderPath, this.getFolderId(folderPath), condition, recursive);
        return folders;
    }

    protected void appendSubFolders(List<ExchangeSession.Folder> folders, String parentFolderPath, FolderId parentFolderId, ExchangeSession.Condition condition, boolean recursive) throws IOException {
        FindFolderMethod findFolderMethod;
        int resultCount = 0;
        do {
            findFolderMethod = new FindFolderMethod(FolderQueryTraversal.SHALLOW, BaseShape.ID_ONLY, parentFolderId, FOLDER_PROPERTIES, (SearchExpression)((Object)condition), resultCount, 500);
            this.executeMethod(findFolderMethod);
            for (EWSMethod.Item item : findFolderMethod.getResponseItems()) {
                ++resultCount;
                Folder folder = this.buildFolder(item);
                folder.folderPath = parentFolderPath.length() > 0 ? (parentFolderPath.endsWith("/") ? parentFolderPath + (String)item.get(Field.get("folderDisplayName").getResponseName()) : parentFolderPath + '/' + (String)item.get(Field.get("folderDisplayName").getResponseName())) : (this.folderIdMap.get(folder.folderId.value) != null ? this.folderIdMap.get(folder.folderId.value) : (String)item.get(Field.get("folderDisplayName").getResponseName()));
                folders.add(folder);
                if (!recursive || !folder.hasChildren) continue;
                this.appendSubFolders(folders, folder.folderPath, folder.folderId, condition, true);
            }
        } while (!findFolderMethod.includesLastItemInRange);
    }

    @Override
    protected Folder internalGetFolder(String folderPath) throws IOException {
        FolderId folderId = this.getFolderId(folderPath);
        GetFolderMethod getFolderMethod = new GetFolderMethod(BaseShape.ID_ONLY, folderId, FOLDER_PROPERTIES);
        this.executeMethod(getFolderMethod);
        EWSMethod.Item item = getFolderMethod.getResponseItem();
        if (item == null) {
            throw new HttpNotFoundException("Folder " + folderPath + " not found");
        }
        Folder folder = this.buildFolder(item);
        folder.folderPath = folderPath;
        return folder;
    }

    @Override
    public int createFolder(String folderPath, String folderClass, Map<String, String> properties) throws IOException {
        FolderPath path = new FolderPath(folderPath);
        EWSMethod.Item folder = new EWSMethod.Item();
        folder.type = "Folder";
        folder.put("FolderClass", folderClass);
        folder.put("DisplayName", path.folderName);
        CreateFolderMethod createFolderMethod = new CreateFolderMethod(this.getFolderId(path.parentPath), folder);
        this.executeMethod(createFolderMethod);
        return 201;
    }

    @Override
    public int updateFolder(String folderPath, Map<String, String> properties) throws IOException {
        ArrayList<FieldUpdate> updates = new ArrayList<FieldUpdate>();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            updates.add(new FieldUpdate(Field.get(entry.getKey()), entry.getValue()));
        }
        UpdateFolderMethod updateFolderMethod = new UpdateFolderMethod(this.internalGetFolder((String)folderPath).folderId, updates);
        this.executeMethod(updateFolderMethod);
        return 201;
    }

    @Override
    public void deleteFolder(String folderPath) throws IOException {
        FolderId folderId = this.getFolderIdIfExists(folderPath);
        if (folderId != null) {
            DeleteFolderMethod deleteFolderMethod = new DeleteFolderMethod(folderId);
            this.executeMethod(deleteFolderMethod);
        } else {
            LOGGER.debug((Object)("Folder " + folderPath + " not found"));
        }
    }

    @Override
    public void moveMessage(ExchangeSession.Message message, String targetFolder) throws IOException {
        MoveItemMethod moveItemMethod = new MoveItemMethod(((Message)message).itemId, this.getFolderId(targetFolder));
        this.executeMethod(moveItemMethod);
    }

    @Override
    public void moveMessages(List<ExchangeSession.Message> messages, String targetFolder) throws IOException {
        ArrayList<ItemId> itemIds = new ArrayList<ItemId>();
        for (ExchangeSession.Message message : messages) {
            itemIds.add(((Message)message).itemId);
        }
        MoveItemMethod moveItemMethod = new MoveItemMethod(itemIds, this.getFolderId(targetFolder));
        this.executeMethod(moveItemMethod);
    }

    @Override
    public void copyMessage(ExchangeSession.Message message, String targetFolder) throws IOException {
        CopyItemMethod copyItemMethod = new CopyItemMethod(((Message)message).itemId, this.getFolderId(targetFolder));
        this.executeMethod(copyItemMethod);
    }

    @Override
    public void copyMessages(List<ExchangeSession.Message> messages, String targetFolder) throws IOException {
        ArrayList<ItemId> itemIds = new ArrayList<ItemId>();
        for (ExchangeSession.Message message : messages) {
            itemIds.add(((Message)message).itemId);
        }
        CopyItemMethod copyItemMethod = new CopyItemMethod(itemIds, this.getFolderId(targetFolder));
        this.executeMethod(copyItemMethod);
    }

    @Override
    public void moveFolder(String folderPath, String targetFolderPath) throws IOException {
        FolderPath path = new FolderPath(folderPath);
        FolderPath targetPath = new FolderPath(targetFolderPath);
        FolderId folderId = this.getFolderId(folderPath);
        FolderId toFolderId = this.getFolderId(targetPath.parentPath);
        toFolderId.changeKey = null;
        if (!path.parentPath.equals(targetPath.parentPath)) {
            MoveFolderMethod moveFolderMethod = new MoveFolderMethod(folderId, toFolderId);
            this.executeMethod(moveFolderMethod);
        }
        if (!path.folderName.equals(targetPath.folderName)) {
            ArrayList<FieldUpdate> updates = new ArrayList<FieldUpdate>();
            updates.add(new FieldUpdate(Field.get("folderDisplayName"), targetPath.folderName));
            UpdateFolderMethod updateFolderMethod = new UpdateFolderMethod(folderId, updates);
            this.executeMethod(updateFolderMethod);
        }
    }

    @Override
    public void moveItem(String sourcePath, String targetPath) throws IOException {
        FolderPath sourceFolderPath = new FolderPath(sourcePath);
        ExchangeSession.Item item = this.getItem(sourceFolderPath.parentPath, sourceFolderPath.folderName);
        FolderPath targetFolderPath = new FolderPath(targetPath);
        FolderId toFolderId = this.getFolderId(targetFolderPath.parentPath);
        MoveItemMethod moveItemMethod = new MoveItemMethod(((Event)item).itemId, toFolderId);
        this.executeMethod(moveItemMethod);
    }

    @Override
    protected void moveToTrash(ExchangeSession.Message message) throws IOException {
        MoveItemMethod moveItemMethod = new MoveItemMethod(((Message)message).itemId, this.getFolderId("Trash"));
        this.executeMethod(moveItemMethod);
    }

    @Override
    public List<ExchangeSession.Contact> searchContacts(String folderPath, Set<String> attributes, ExchangeSession.Condition condition, int maxCount) throws IOException {
        ArrayList<ExchangeSession.Contact> contacts = new ArrayList<ExchangeSession.Contact>();
        List<EWSMethod.Item> responses = this.searchItems(folderPath, attributes, condition, FolderQueryTraversal.SHALLOW, maxCount);
        for (EWSMethod.Item response : responses) {
            contacts.add(new Contact(response));
        }
        return contacts;
    }

    @Override
    protected ExchangeSession.Condition getCalendarItemCondition(ExchangeSession.Condition dateCondition) {
        return this.or(this.or(this.isTrue("isrecurring"), this.and(this.isFalse("isrecurring"), dateCondition)), this.or(this.isEqualTo("instancetype", 1), this.and(this.isEqualTo("instancetype", 0), dateCondition)));
    }

    @Override
    public List<ExchangeSession.Event> getEventMessages(String folderPath) throws IOException {
        return this.searchEvents(folderPath, ITEM_PROPERTIES, this.and(this.startsWith("outlookmessageclass", "IPM.Schedule.Meeting."), this.or(this.isNull("processed"), this.isFalse("processed"))));
    }

    @Override
    public List<ExchangeSession.Event> searchEvents(String folderPath, Set<String> attributes, ExchangeSession.Condition condition) throws IOException {
        ArrayList<ExchangeSession.Event> events = new ArrayList<ExchangeSession.Event>();
        List<EWSMethod.Item> responses = this.searchItems(folderPath, attributes, condition, FolderQueryTraversal.SHALLOW, 0);
        for (EWSMethod.Item response : responses) {
            Event event = new Event(folderPath, response);
            if ("Message".equals(event.type)) {
                try {
                    event.getEventContent();
                    events.add(event);
                }
                catch (HttpException e) {
                    LOGGER.warn((Object)("Ignore invalid event " + event.getHref()));
                }
                continue;
            }
            if (event.isException) {
                LOGGER.debug((Object)("Exclude recurrence exception " + event.getHref()));
                continue;
            }
            events.add(event);
        }
        return events;
    }

    @Override
    protected Set<String> getItemProperties() {
        return ITEM_PROPERTIES;
    }

    protected EWSMethod.Item getEwsItem(String folderPath, String itemName) throws IOException {
        List<EWSMethod.Item> responses;
        EWSMethod.Item item = null;
        String urlcompname = this.convertItemNameToEML(itemName);
        if (EwsExchangeSession.isItemId(urlcompname)) {
            ItemId itemId = new ItemId(StringUtil.urlToBase64(urlcompname.substring(0, urlcompname.indexOf(46))));
            GetItemMethod getItemMethod = new GetItemMethod(BaseShape.ID_ONLY, itemId, false);
            for (String attribute : EVENT_REQUEST_PROPERTIES) {
                getItemMethod.addAdditionalProperty(Field.get(attribute));
            }
            this.executeMethod(getItemMethod);
            item = getItemMethod.getResponseItem();
        }
        if (item == null && !(responses = this.searchItems(folderPath, EVENT_REQUEST_PROPERTIES, this.isEqualTo("urlcompname", urlcompname), FolderQueryTraversal.SHALLOW, 0)).isEmpty()) {
            item = responses.get(0);
        }
        return item;
    }

    @Override
    public ExchangeSession.Item getItem(String folderPath, String itemName) throws IOException {
        EWSMethod.Item item = this.getEwsItem(folderPath, itemName);
        if (item == null && this.isMainCalendar(folderPath)) {
            if (itemName.endsWith(".ics")) {
                itemName = itemName.substring(0, itemName.length() - 3) + "EML";
            }
            item = this.getEwsItem("tasks", itemName);
        }
        if (item == null) {
            throw new HttpNotFoundException(itemName + " not found in " + folderPath);
        }
        String itemType = item.type;
        if ("Contact".equals(itemType)) {
            ItemId itemId = new ItemId(item);
            GetItemMethod getItemMethod = new GetItemMethod(BaseShape.ID_ONLY, itemId, false);
            for (String attribute : CONTACT_ATTRIBUTES) {
                getItemMethod.addAdditionalProperty(Field.get(attribute));
            }
            this.executeMethod(getItemMethod);
            item = getItemMethod.getResponseItem();
            if (item == null) {
                throw new HttpNotFoundException(itemName + " not found in " + folderPath);
            }
            return new Contact(item);
        }
        if ("CalendarItem".equals(itemType) || "MeetingRequest".equals(itemType) || "Task".equals(itemType) || "Message".equals(itemType)) {
            return new Event(folderPath, item);
        }
        throw new HttpNotFoundException(itemName + " not found in " + folderPath);
    }

    @Override
    public ExchangeSession.ContactPhoto getContactPhoto(ExchangeSession.Contact contact) throws IOException {
        GetItemMethod getItemMethod = new GetItemMethod(BaseShape.ID_ONLY, ((Contact)contact).itemId, false);
        getItemMethod.addAdditionalProperty(Field.get("attachments"));
        this.executeMethod(getItemMethod);
        EWSMethod.Item item = getItemMethod.getResponseItem();
        if (item == null) {
            throw new IOException("Missing contact picture");
        }
        FileAttachment attachment = item.getAttachmentByName("ContactPicture.jpg");
        if (attachment == null) {
            throw new IOException("Missing contact picture");
        }
        GetAttachmentMethod getAttachmentMethod = new GetAttachmentMethod(attachment.attachmentId);
        this.executeMethod(getAttachmentMethod);
        ExchangeSession.ContactPhoto contactPhoto = new ExchangeSession.ContactPhoto();
        contactPhoto.content = (String)getAttachmentMethod.getResponseItem().get("Content");
        contactPhoto.contentType = attachment.contentType == null ? "image/jpeg" : attachment.contentType;
        return contactPhoto;
    }

    @Override
    public void deleteItem(String folderPath, String itemName) throws IOException {
        EWSMethod.Item item = this.getEwsItem(folderPath, itemName);
        if (item == null && this.isMainCalendar(folderPath)) {
            item = this.getEwsItem("tasks", itemName);
        }
        if (item != null) {
            DeleteItemMethod deleteItemMethod = new DeleteItemMethod(new ItemId(item), DeleteType.HardDelete, SendMeetingCancellations.SendToNone);
            this.executeMethod(deleteItemMethod);
        }
    }

    @Override
    public void processItem(String folderPath, String itemName) throws IOException {
        EWSMethod.Item item = this.getEwsItem(folderPath, itemName);
        if (item != null) {
            HashMap<String, String> localProperties = new HashMap<String, String>();
            localProperties.put("processed", "1");
            localProperties.put("read", "1");
            UpdateItemMethod updateItemMethod = new UpdateItemMethod(MessageDisposition.SaveOnly, ConflictResolution.AlwaysOverwrite, SendMeetingInvitationsOrCancellations.SendToNone, new ItemId(item), this.buildProperties(localProperties));
            this.executeMethod(updateItemMethod);
        }
    }

    @Override
    public int sendEvent(String icsBody) throws IOException {
        String itemName = UUID.randomUUID().toString() + ".EML";
        byte[] mimeContent = new Event("Drafts", itemName, "urn:content-classes:calendarmessage", icsBody, null, null).createMimeContent();
        if (mimeContent == null) {
            return 204;
        }
        this.sendMessage(null, mimeContent);
        return 200;
    }

    @Override
    protected ExchangeSession.ItemResult internalCreateOrUpdateContact(String folderPath, String itemName, Map<String, String> properties, String etag, String noneMatch) throws IOException {
        return new Contact(folderPath, itemName, properties, StringUtil.removeQuotes(etag), noneMatch).createOrUpdate();
    }

    @Override
    protected ExchangeSession.ItemResult internalCreateOrUpdateEvent(String folderPath, String itemName, String contentClass, String icsBody, String etag, String noneMatch) throws IOException {
        return new Event(folderPath, itemName, contentClass, icsBody, StringUtil.removeQuotes(etag), noneMatch).createOrUpdate();
    }

    @Override
    public boolean isSharedFolder(String folderPath) {
        return folderPath.startsWith("/") && !folderPath.toLowerCase().startsWith(this.currentMailboxPath);
    }

    @Override
    public boolean isMainCalendar(String folderPath) throws IOException {
        FolderId currentFolderId = this.getFolderId(folderPath);
        FolderId calendarFolderId = this.getFolderId("calendar");
        return calendarFolderId.name.equals(currentFolderId.name) && calendarFolderId.value.equals(currentFolderId.value);
    }

    @Override
    protected String getFreeBusyData(String attendee, String start, String end, int interval) throws IOException {
        GetUserAvailabilityMethod getUserAvailabilityMethod = new GetUserAvailabilityMethod(attendee, start, end, interval);
        this.executeMethod(getUserAvailabilityMethod);
        return getUserAvailabilityMethod.getMergedFreeBusy();
    }

    @Override
    protected void loadVtimezone() {
        try {
            String timezoneId = null;
            if (!"Exchange2007_SP1".equals(this.serverVersion)) {
                GetUserConfigurationMethod getUserConfigurationMethod = new GetUserConfigurationMethod();
                this.executeMethod(getUserConfigurationMethod);
                EWSMethod.Item item = getUserConfigurationMethod.getResponseItem();
                if (item != null) {
                    timezoneId = (String)item.get("timezone");
                }
            } else if (!this.directEws) {
                timezoneId = this.getTimezoneidFromOptions();
            }
            if (timezoneId == null) {
                timezoneId = Settings.getProperty("davmail.timezoneId");
            }
            if (timezoneId == null) {
                LOGGER.warn((Object)"Unable to get user timezone, using GMT Standard Time. Set davmail.timezoneId setting to override this.");
                timezoneId = "GMT Standard Time";
            }
            this.createCalendarFolder("davmailtemp", null);
            EWSMethod.Item item = new EWSMethod.Item();
            item.type = "CalendarItem";
            if (!"Exchange2007_SP1".equals(this.serverVersion)) {
                SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.ENGLISH);
                dateFormatter.setTimeZone(GMT_TIMEZONE);
                Calendar cal = Calendar.getInstance();
                item.put("Start", dateFormatter.format(cal.getTime()));
                cal.add(5, 1);
                item.put("End", dateFormatter.format(cal.getTime()));
                item.put("StartTimeZone", timezoneId);
            } else {
                item.put("MeetingTimeZone", timezoneId);
            }
            CreateItemMethod createItemMethod = new CreateItemMethod(MessageDisposition.SaveOnly, SendMeetingInvitations.SendToNone, this.getFolderId("davmailtemp"), item);
            this.executeMethod(createItemMethod);
            item = createItemMethod.getResponseItem();
            VCalendar vCalendar = new VCalendar(this.getContent(new ItemId(item)), this.email, null);
            this.vTimezone = vCalendar.getVTimezone();
            this.deleteFolder("davmailtemp");
        }
        catch (IOException e) {
            LOGGER.warn((Object)("Unable to get VTIMEZONE info: " + e), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getTimezoneidFromOptions() {
        String result = null;
        BufferedReader optionsPageReader = null;
        GetMethod optionsMethod = new GetMethod("/owa/?ae=Options&t=Regional");
        try {
            String line;
            DavGatewayHttpClientFacade.executeGetMethod(this.httpClient, optionsMethod, false);
            optionsPageReader = new BufferedReader(new InputStreamReader(optionsMethod.getResponseBodyAsStream(), "UTF-8"));
            while ((line = optionsPageReader.readLine()) != null && !line.contains("tblTmZn") && !line.contains("selTmZn")) {
            }
            if (line != null) {
                if (line.contains("tblTmZn")) {
                    int start = line.indexOf("oV=\"") + 4;
                    int end = line.indexOf(34, start);
                    result = line.substring(start, end);
                } else {
                    int end = line.lastIndexOf("\" selected>");
                    int start = line.lastIndexOf(34, end - 1);
                    result = line.substring(start + 1, end);
                }
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)("Error parsing options page at " + optionsMethod.getPath()));
        }
        finally {
            if (optionsPageReader != null) {
                try {
                    optionsPageReader.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)("Error parsing options page at " + optionsMethod.getPath()));
                }
            }
            optionsMethod.releaseConnection();
        }
        return result;
    }

    protected FolderId getFolderId(String folderPath) throws IOException {
        FolderId folderId = this.getFolderIdIfExists(folderPath);
        if (folderId == null) {
            throw new HttpNotFoundException("Folder '" + folderPath + "' not found");
        }
        return folderId;
    }

    protected FolderId getFolderIdIfExists(String folderPath) throws IOException {
        String lowerCaseFolderPath = folderPath.toLowerCase();
        if (lowerCaseFolderPath.equals(this.currentMailboxPath)) {
            return this.getSubFolderIdIfExists(null, "");
        }
        if (lowerCaseFolderPath.startsWith(this.currentMailboxPath + '/')) {
            return this.getSubFolderIdIfExists(null, folderPath.substring(this.currentMailboxPath.length() + 1));
        }
        if (folderPath.startsWith(USERS_ROOT)) {
            String subFolderPath;
            String mailbox;
            int slashIndex = folderPath.indexOf(47, USERS_ROOT.length());
            if (slashIndex >= 0) {
                mailbox = folderPath.substring(USERS_ROOT.length(), slashIndex);
                subFolderPath = folderPath.substring(slashIndex + 1);
            } else {
                mailbox = folderPath.substring(USERS_ROOT.length());
                subFolderPath = "";
            }
            return this.getSubFolderIdIfExists(mailbox, subFolderPath);
        }
        return this.getSubFolderIdIfExists(null, folderPath);
    }

    protected FolderId getSubFolderIdIfExists(String mailbox, String folderPath) throws IOException {
        String[] folderNames;
        FolderId currentFolderId;
        if (folderPath.startsWith("/public/")) {
            currentFolderId = DistinguishedFolderId.getInstance(mailbox, DistinguishedFolderId.Name.publicfoldersroot);
            folderNames = folderPath.substring("/public/".length()).split("/");
        } else if (folderPath.startsWith(ARCHIVE_ROOT)) {
            currentFolderId = DistinguishedFolderId.getInstance(mailbox, DistinguishedFolderId.Name.archivemsgfolderroot);
            folderNames = folderPath.substring(ARCHIVE_ROOT.length()).split("/");
        } else if (folderPath.startsWith("INBOX") || folderPath.startsWith("inbox")) {
            currentFolderId = DistinguishedFolderId.getInstance(mailbox, DistinguishedFolderId.Name.inbox);
            folderNames = folderPath.substring("INBOX".length()).split("/");
        } else if (folderPath.startsWith("calendar")) {
            currentFolderId = DistinguishedFolderId.getInstance(mailbox, DistinguishedFolderId.Name.calendar);
            folderNames = folderPath.substring("calendar".length()).split("/");
        } else if (folderPath.startsWith("tasks")) {
            currentFolderId = DistinguishedFolderId.getInstance(mailbox, DistinguishedFolderId.Name.tasks);
            folderNames = folderPath.substring("tasks".length()).split("/");
        } else if (folderPath.startsWith("contacts")) {
            currentFolderId = DistinguishedFolderId.getInstance(mailbox, DistinguishedFolderId.Name.contacts);
            folderNames = folderPath.substring("contacts".length()).split("/");
        } else if (folderPath.startsWith("Sent")) {
            currentFolderId = DistinguishedFolderId.getInstance(mailbox, DistinguishedFolderId.Name.sentitems);
            folderNames = folderPath.substring("Sent".length()).split("/");
        } else if (folderPath.startsWith("Drafts")) {
            currentFolderId = DistinguishedFolderId.getInstance(mailbox, DistinguishedFolderId.Name.drafts);
            folderNames = folderPath.substring("Drafts".length()).split("/");
        } else if (folderPath.startsWith("Trash")) {
            currentFolderId = DistinguishedFolderId.getInstance(mailbox, DistinguishedFolderId.Name.deleteditems);
            folderNames = folderPath.substring("Trash".length()).split("/");
        } else if (folderPath.startsWith("Junk")) {
            currentFolderId = DistinguishedFolderId.getInstance(mailbox, DistinguishedFolderId.Name.junkemail);
            folderNames = folderPath.substring("Junk".length()).split("/");
        } else if (folderPath.startsWith("Unsent Messages")) {
            currentFolderId = DistinguishedFolderId.getInstance(mailbox, DistinguishedFolderId.Name.outbox);
            folderNames = folderPath.substring("Unsent Messages".length()).split("/");
        } else {
            currentFolderId = DistinguishedFolderId.getInstance(mailbox, DistinguishedFolderId.Name.msgfolderroot);
            folderNames = folderPath.split("/");
        }
        for (String folderName : folderNames) {
            if (folderName.length() > 0 && (currentFolderId = this.getSubFolderByName(currentFolderId, folderName)) == null) break;
        }
        return currentFolderId;
    }

    protected FolderId getSubFolderByName(FolderId parentFolderId, String folderName) throws IOException {
        FolderId folderId = null;
        FindFolderMethod findFolderMethod = new FindFolderMethod(FolderQueryTraversal.SHALLOW, BaseShape.ID_ONLY, parentFolderId, FOLDER_PROPERTIES, new TwoOperandExpression(TwoOperandExpression.Operator.IsEqualTo, Field.get("folderDisplayName"), folderName), 0, 1);
        this.executeMethod(findFolderMethod);
        EWSMethod.Item item = findFolderMethod.getResponseItem();
        if (item != null) {
            folderId = new FolderId(item);
        }
        return folderId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeMethod(EWSMethod ewsMethod) throws IOException {
        try {
            ewsMethod.setServerVersion(this.serverVersion);
            this.httpClient.executeMethod((HttpMethod)ewsMethod);
            if (this.serverVersion == null) {
                this.serverVersion = ewsMethod.getServerVersion();
            }
            ewsMethod.checkSuccess();
        }
        finally {
            ewsMethod.releaseConnection();
        }
    }

    protected Contact buildGalfindContact(EWSMethod.Item response) {
        Contact contact = new Contact();
        contact.setName((String)response.get("Name"));
        contact.put("imapUid", response.get("Name"));
        contact.put("uid", response.get("Name"));
        if (LOGGER.isDebugEnabled()) {
            for (Map.Entry<Object, Object> entry : response.entrySet()) {
                String key = (String)entry.getKey();
                if (IGNORE_ATTRIBUTE_SET.contains(key) || GALFIND_ATTRIBUTE_MAP.containsValue(key)) continue;
                LOGGER.debug((Object)("Unsupported ResolveNames " + contact.getName() + " response attribute: " + key + " value: " + (String)entry.getValue()));
            }
        }
        for (Map.Entry<Object, Object> entry : GALFIND_ATTRIBUTE_MAP.entrySet()) {
            String attributeValue = (String)response.get(entry.getValue());
            if (attributeValue == null) continue;
            contact.put(entry.getKey(), attributeValue);
        }
        return contact;
    }

    @Override
    public Map<String, ExchangeSession.Contact> galFind(ExchangeSession.Condition condition, Set<String> returningAttributes, int sizeLimit) throws IOException {
        HashMap<String, ExchangeSession.Contact> contacts;
        block9: {
            String mappedAttributeName;
            block7: {
                ExchangeSession.Operator operator;
                List<ExchangeSession.Condition> conditions;
                block8: {
                    contacts = new HashMap<String, ExchangeSession.Contact>();
                    if (!(condition instanceof MultiCondition)) break block7;
                    conditions = ((ExchangeSession.MultiCondition)condition).getConditions();
                    operator = ((ExchangeSession.MultiCondition)condition).getOperator();
                    if (operator != ExchangeSession.Operator.Or) break block8;
                    for (ExchangeSession.Condition innerCondition : conditions) {
                        contacts.putAll(this.galFind(innerCondition, returningAttributes, sizeLimit));
                    }
                    break block9;
                }
                if (operator != ExchangeSession.Operator.And || conditions.isEmpty()) break block9;
                Map<String, ExchangeSession.Contact> innerContacts = this.galFind(conditions.get(0), returningAttributes, sizeLimit);
                for (ExchangeSession.Contact contact : innerContacts.values()) {
                    if (!condition.isMatch(contact)) continue;
                    contacts.put(contact.getName().toLowerCase(), contact);
                }
                break block9;
            }
            if (condition instanceof AttributeCondition && (mappedAttributeName = GALFIND_ATTRIBUTE_MAP.get(((ExchangeSession.AttributeCondition)condition).getAttributeName())) != null) {
                String value = ((ExchangeSession.AttributeCondition)condition).getValue().toLowerCase();
                ExchangeSession.Operator operator = ((AttributeCondition)condition).getOperator();
                String searchValue = value;
                if (mappedAttributeName.startsWith("EmailAddress")) {
                    searchValue = "smtp:" + searchValue;
                }
                if (operator == ExchangeSession.Operator.IsEqualTo) {
                    searchValue = '=' + searchValue;
                }
                ResolveNamesMethod resolveNamesMethod = new ResolveNamesMethod(searchValue);
                this.executeMethod(resolveNamesMethod);
                List<EWSMethod.Item> responses = resolveNamesMethod.getResponseItems();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("ResolveNames(" + searchValue + ") returned " + responses.size() + " results"));
                }
                for (EWSMethod.Item response : responses) {
                    Contact contact = this.buildGalfindContact(response);
                    if (!condition.isMatch(contact)) continue;
                    contacts.put(contact.getName().toLowerCase(), contact);
                }
            }
        }
        return contacts;
    }

    protected Date parseDateFromExchange(String exchangeDateValue) throws DavMailException {
        Date dateValue = null;
        if (exchangeDateValue != null) {
            try {
                dateValue = EwsExchangeSession.getExchangeZuluDateFormat().parse(exchangeDateValue);
            }
            catch (ParseException e) {
                throw new DavMailException("EXCEPTION_INVALID_DATE", exchangeDateValue);
            }
        }
        return dateValue;
    }

    protected String convertDateFromExchange(String exchangeDateValue) throws DavMailException {
        String zuluDateValue = null;
        if (exchangeDateValue != null) {
            try {
                zuluDateValue = EwsExchangeSession.getZuluDateFormat().format(EwsExchangeSession.getExchangeZuluDateFormat().parse(exchangeDateValue));
            }
            catch (ParseException e) {
                throw new DavMailException("EXCEPTION_INVALID_DATE", exchangeDateValue);
            }
        }
        return zuluDateValue;
    }

    protected String convertCalendarDateToExchange(String vcalendarDateValue) throws DavMailException {
        String zuluDateValue = null;
        if (vcalendarDateValue != null) {
            try {
                SimpleDateFormat dateParser = vcalendarDateValue.length() == 8 ? new SimpleDateFormat("yyyyMMdd", Locale.ENGLISH) : new SimpleDateFormat("yyyyMMdd'T'HHmmss", Locale.ENGLISH);
                dateParser.setTimeZone(GMT_TIMEZONE);
                SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.ENGLISH);
                dateFormatter.setTimeZone(GMT_TIMEZONE);
                zuluDateValue = dateFormatter.format(dateParser.parse(vcalendarDateValue));
            }
            catch (ParseException e) {
                throw new DavMailException("EXCEPTION_INVALID_DATE", vcalendarDateValue);
            }
        }
        return zuluDateValue;
    }

    protected String convertDateFromExchangeToTaskDate(String exchangeDateValue) throws DavMailException {
        String zuluDateValue = null;
        if (exchangeDateValue != null) {
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd", Locale.ENGLISH);
                dateFormat.setTimeZone(GMT_TIMEZONE);
                zuluDateValue = dateFormat.format(EwsExchangeSession.getExchangeZuluDateFormat().parse(exchangeDateValue));
            }
            catch (ParseException e) {
                throw new DavMailException("EXCEPTION_INVALID_DATE", exchangeDateValue);
            }
        }
        return zuluDateValue;
    }

    protected String convertTaskDateToZulu(String value) {
        String result = null;
        if (value != null && value.length() > 0) {
            try {
                SimpleDateFormat parser;
                if (value.length() == 8) {
                    parser = new SimpleDateFormat("yyyyMMdd", Locale.ENGLISH);
                    parser.setTimeZone(GMT_TIMEZONE);
                } else if (value.length() == 15) {
                    parser = new SimpleDateFormat("yyyyMMdd'T'HHmmss", Locale.ENGLISH);
                    parser.setTimeZone(GMT_TIMEZONE);
                } else if (value.length() == 16) {
                    parser = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'", Locale.ENGLISH);
                    parser.setTimeZone(GMT_TIMEZONE);
                } else {
                    parser = ExchangeSession.getExchangeZuluDateFormat();
                }
                Calendar calendarValue = Calendar.getInstance(GMT_TIMEZONE);
                calendarValue.setTime(parser.parse(value));
                if (value.length() == 16) {
                    calendarValue.add(10, 12);
                }
                calendarValue.set(10, 0);
                calendarValue.set(12, 0);
                calendarValue.set(13, 0);
                result = ExchangeSession.getExchangeZuluDateFormat().format(calendarValue.getTime());
            }
            catch (ParseException e) {
                LOGGER.warn((Object)("Invalid date: " + value));
            }
        }
        return result;
    }

    @Override
    public String formatSearchDate(Date date) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.ENGLISH);
        dateFormatter.setTimeZone(GMT_TIMEZONE);
        return dateFormatter.format(date);
    }

    protected static boolean isItemId(String itemName) {
        return itemName.length() >= 152 && itemName.indexOf(32) < 0;
    }

    protected String convertPriorityFromExchange(String exchangeImportanceValue) {
        String value = null;
        if (exchangeImportanceValue != null) {
            value = importanceToPriorityMap.get(exchangeImportanceValue);
        }
        return value;
    }

    protected String convertPriorityToExchange(String vTodoPriorityValue) {
        String value = null;
        if (vTodoPriorityValue != null) {
            value = priorityToImportanceMap.get(vTodoPriorityValue);
        }
        return value;
    }

    static {
        MESSAGE_TYPES.add("Message");
        MESSAGE_TYPES.add("CalendarItem");
        MESSAGE_TYPES.add("MeetingMessage");
        MESSAGE_TYPES.add("MeetingRequest");
        MESSAGE_TYPES.add("MeetingResponse");
        MESSAGE_TYPES.add("MeetingCancellation");
        MESSAGE_TYPES.add("Item");
        MESSAGE_TYPES.add("PostItem");
        vTodoToTaskStatusMap = new HashMap<String, String>();
        taskTovTodoStatusMap = new HashMap<String, String>();
        taskTovTodoStatusMap.put("InProgress", "IN-PROCESS");
        taskTovTodoStatusMap.put("Completed", "COMPLETED");
        taskTovTodoStatusMap.put("WaitingOnOthers", "NEEDS-ACTION");
        taskTovTodoStatusMap.put("Deferred", "CANCELLED");
        vTodoToTaskStatusMap.put("IN-PROCESS", "InProgress");
        vTodoToTaskStatusMap.put("COMPLETED", "Completed");
        vTodoToTaskStatusMap.put("NEEDS-ACTION", "WaitingOnOthers");
        vTodoToTaskStatusMap.put("CANCELLED", "Deferred");
        FOLDER_PROPERTIES = new HashSet();
        FOLDER_PROPERTIES.add(Field.get("urlcompname"));
        FOLDER_PROPERTIES.add(Field.get("folderDisplayName"));
        FOLDER_PROPERTIES.add(Field.get("lastmodified"));
        FOLDER_PROPERTIES.add(Field.get("folderclass"));
        FOLDER_PROPERTIES.add(Field.get("ctag"));
        FOLDER_PROPERTIES.add(Field.get("count"));
        FOLDER_PROPERTIES.add(Field.get("unread"));
        FOLDER_PROPERTIES.add(Field.get("hassubs"));
        FOLDER_PROPERTIES.add(Field.get("uidNext"));
        FOLDER_PROPERTIES.add(Field.get("highestUid"));
        ITEM_PROPERTIES = new HashSet<String>();
        ITEM_PROPERTIES.add("etag");
        ITEM_PROPERTIES.add("displayname");
        ITEM_PROPERTIES.add("instancetype");
        ITEM_PROPERTIES.add("urlcompname");
        ITEM_PROPERTIES.add("subject");
        EVENT_REQUEST_PROPERTIES = new HashSet();
        EVENT_REQUEST_PROPERTIES.add("permanenturl");
        EVENT_REQUEST_PROPERTIES.add("etag");
        EVENT_REQUEST_PROPERTIES.add("displayname");
        EVENT_REQUEST_PROPERTIES.add("subject");
        EVENT_REQUEST_PROPERTIES.add("urlcompname");
        GALFIND_ATTRIBUTE_MAP = new HashMap();
        GALFIND_ATTRIBUTE_MAP.put("imapUid", "Name");
        GALFIND_ATTRIBUTE_MAP.put("cn", "DisplayName");
        GALFIND_ATTRIBUTE_MAP.put("givenName", "GivenName");
        GALFIND_ATTRIBUTE_MAP.put("sn", "Surname");
        GALFIND_ATTRIBUTE_MAP.put("smtpemail1", "EmailAddress");
        GALFIND_ATTRIBUTE_MAP.put("roomnumber", "OfficeLocation");
        GALFIND_ATTRIBUTE_MAP.put("street", "BusinessStreet");
        GALFIND_ATTRIBUTE_MAP.put("l", "BusinessCity");
        GALFIND_ATTRIBUTE_MAP.put("o", "CompanyName");
        GALFIND_ATTRIBUTE_MAP.put("postalcode", "BusinessPostalCode");
        GALFIND_ATTRIBUTE_MAP.put("st", "BusinessState");
        GALFIND_ATTRIBUTE_MAP.put("co", "BusinessCountryOrRegion");
        GALFIND_ATTRIBUTE_MAP.put("manager", "Manager");
        GALFIND_ATTRIBUTE_MAP.put("middlename", "Initials");
        GALFIND_ATTRIBUTE_MAP.put("title", "JobTitle");
        GALFIND_ATTRIBUTE_MAP.put("department", "Department");
        GALFIND_ATTRIBUTE_MAP.put("otherTelephone", "OtherTelephone");
        GALFIND_ATTRIBUTE_MAP.put("telephoneNumber", "BusinessPhone");
        GALFIND_ATTRIBUTE_MAP.put("mobile", "MobilePhone");
        GALFIND_ATTRIBUTE_MAP.put("facsimiletelephonenumber", "BusinessFax");
        GALFIND_ATTRIBUTE_MAP.put("secretarycn", "AssistantName");
        IGNORE_ATTRIBUTE_SET = new HashSet();
        IGNORE_ATTRIBUTE_SET.add("ContactSource");
        IGNORE_ATTRIBUTE_SET.add("Culture");
        IGNORE_ATTRIBUTE_SET.add("AssistantPhone");
        importanceToPriorityMap = new HashMap<String, String>();
        importanceToPriorityMap.put("High", "1");
        importanceToPriorityMap.put("Normal", "5");
        importanceToPriorityMap.put("Low", "9");
        priorityToImportanceMap = new HashMap<String, String>();
        priorityToImportanceMap.put("1", "High");
        priorityToImportanceMap.put("5", "Normal");
        priorityToImportanceMap.put("9", "Low");
    }

    protected class Event
    extends ExchangeSession.Event {
        ItemId itemId;
        String type;
        boolean isException;

        protected Event(String folderPath, EWSMethod.Item response) {
            this.folderPath = folderPath;
            this.itemId = new ItemId(response);
            this.type = response.type;
            this.permanentUrl = (String)response.get(Field.get("permanenturl").getResponseName());
            this.etag = (String)response.get(Field.get("etag").getResponseName());
            this.displayName = (String)response.get(Field.get("displayname").getResponseName());
            this.subject = (String)response.get(Field.get("subject").getResponseName());
            this.itemName = StringUtil.decodeUrlcompname((String)response.get(Field.get("urlcompname").getResponseName()));
            if (this.itemName == null) {
                this.itemName = StringUtil.base64ToUrl(this.itemId.id) + ".EML";
            }
            String instancetype = (String)response.get(Field.get("instancetype").getResponseName());
            this.isException = "3".equals(instancetype);
        }

        protected Event(String folderPath, String itemName, String contentClass, String itemBody, String etag, String noneMatch) throws IOException {
            super(folderPath, itemName, contentClass, itemBody, etag, noneMatch);
        }

        public ExchangeSession.ItemResult createOrUpdate() throws IOException {
            EWSMethod createOrUpdateItemMethod;
            ArrayList<FieldUpdate> updates;
            EWSMethod.Item newItem;
            if (this.vCalendar.isTodo() && EwsExchangeSession.this.isMainCalendar(this.folderPath)) {
                this.folderPath = "tasks";
            }
            ExchangeSession.ItemResult itemResult = new ExchangeSession.ItemResult();
            String currentEtag = null;
            ItemId currentItemId = null;
            String ownerResponseReply = null;
            EWSMethod.Item currentItem = EwsExchangeSession.this.getEwsItem(this.folderPath, this.itemName);
            if (currentItem != null) {
                currentItemId = new ItemId(currentItem);
                currentEtag = (String)currentItem.get(Field.get("etag").getResponseName());
                LOGGER.debug((Object)("Existing item found with etag: " + currentEtag + " client etag: " + this.etag + " id: " + currentItemId.id));
            }
            if ("*".equals(this.noneMatch)) {
                if (currentItemId != null) {
                    itemResult.status = 412;
                    return itemResult;
                }
            } else if (!(this.etag == null || currentItemId != null && this.etag.equals(currentEtag))) {
                itemResult.status = 412;
                return itemResult;
            }
            if (this.vCalendar.isTodo()) {
                newItem = new EWSMethod.Item();
                newItem.type = "Task";
                updates = new ArrayList<FieldUpdate>();
                updates.add(Field.createFieldUpdate("importance", EwsExchangeSession.this.convertPriorityToExchange(this.vCalendar.getFirstVeventPropertyValue("PRIORITY"))));
                updates.add(Field.createFieldUpdate("calendaruid", this.vCalendar.getFirstVeventPropertyValue("UID")));
                updates.add(Field.createFieldUpdate("urlcompname", EwsExchangeSession.this.convertItemNameToEML(this.itemName)));
                updates.add(Field.createFieldUpdate("subject", this.vCalendar.getFirstVeventPropertyValue("SUMMARY")));
                updates.add(Field.createFieldUpdate("description", this.vCalendar.getFirstVeventPropertyValue("DESCRIPTION")));
                updates.add(Field.createFieldUpdate("keywords", this.vCalendar.getFirstVeventPropertyValue("CATEGORIES")));
                updates.add(Field.createFieldUpdate("startdate", EwsExchangeSession.this.convertTaskDateToZulu(this.vCalendar.getFirstVeventPropertyValue("DTSTART"))));
                updates.add(Field.createFieldUpdate("duedate", EwsExchangeSession.this.convertTaskDateToZulu(this.vCalendar.getFirstVeventPropertyValue("DUE"))));
                updates.add(Field.createFieldUpdate("datecompleted", EwsExchangeSession.this.convertTaskDateToZulu(this.vCalendar.getFirstVeventPropertyValue("COMPLETED"))));
                updates.add(Field.createFieldUpdate("commonstart", EwsExchangeSession.this.convertTaskDateToZulu(this.vCalendar.getFirstVeventPropertyValue("DTSTART"))));
                updates.add(Field.createFieldUpdate("commonend", EwsExchangeSession.this.convertTaskDateToZulu(this.vCalendar.getFirstVeventPropertyValue("DUE"))));
                String percentComplete = this.vCalendar.getFirstVeventPropertyValue("PERCENT-COMPLETE");
                if (percentComplete == null) {
                    percentComplete = "0";
                }
                updates.add(Field.createFieldUpdate("percentcomplete", percentComplete));
                String vTodoStatus = this.vCalendar.getFirstVeventPropertyValue("STATUS");
                if (vTodoStatus == null) {
                    updates.add(Field.createFieldUpdate("taskstatus", "NotStarted"));
                } else {
                    updates.add(Field.createFieldUpdate("taskstatus", vTodoToTaskStatusMap.get(vTodoStatus)));
                }
                if (currentItemId != null) {
                    createOrUpdateItemMethod = new UpdateItemMethod(MessageDisposition.SaveOnly, ConflictResolution.AutoResolve, SendMeetingInvitationsOrCancellations.SendToNone, currentItemId, updates);
                } else {
                    newItem.setFieldUpdates(updates);
                    createOrUpdateItemMethod = new CreateItemMethod(MessageDisposition.SaveOnly, SendMeetingInvitations.SendToNone, EwsExchangeSession.this.getFolderId(this.folderPath), newItem);
                }
            } else {
                String xMozSnoozeTime;
                String xMozLastack;
                if (currentItemId != null) {
                    DeleteItemMethod deleteItemMethod = new DeleteItemMethod(currentItemId, DeleteType.HardDelete, SendMeetingCancellations.SendToNone);
                    EwsExchangeSession.this.executeMethod(deleteItemMethod);
                }
                newItem = new EWSMethod.Item();
                newItem.type = "CalendarItem";
                newItem.mimeContent = IOUtil.encodeBase64(this.vCalendar.toString());
                updates = new ArrayList();
                if (!this.vCalendar.hasVAlarm()) {
                    updates.add(Field.createFieldUpdate("reminderset", "false"));
                }
                updates.add(Field.createFieldUpdate("urlcompname", EwsExchangeSession.this.convertItemNameToEML(this.itemName)));
                if (this.vCalendar.isMeeting()) {
                    if (this.vCalendar.isMeetingOrganizer()) {
                        updates.add(Field.createFieldUpdate("apptstateflags", "1"));
                    } else {
                        updates.add(Field.createFieldUpdate("apptstateflags", "3"));
                    }
                } else {
                    updates.add(Field.createFieldUpdate("apptstateflags", "0"));
                }
                String xMozSendInvitations = this.vCalendar.getFirstVeventPropertyValue("X-MOZ-SEND-INVITATIONS");
                if (xMozSendInvitations != null) {
                    updates.add(Field.createFieldUpdate("xmozsendinvitations", xMozSendInvitations));
                }
                if ((xMozLastack = this.vCalendar.getFirstVeventPropertyValue("X-MOZ-LASTACK")) != null) {
                    updates.add(Field.createFieldUpdate("xmozlastack", xMozLastack));
                }
                if ((xMozSnoozeTime = this.vCalendar.getFirstVeventPropertyValue("X-MOZ-SNOOZE-TIME")) != null) {
                    updates.add(Field.createFieldUpdate("xmozsnoozetime", xMozSnoozeTime));
                }
                if (this.vCalendar.isMeeting() && "Exchange2007_SP1".equals(EwsExchangeSession.this.serverVersion)) {
                    String organizerEmail;
                    List<VProperty> organizerProperties;
                    VProperty property2;
                    HashSet<String> requiredAttendees = new HashSet<String>();
                    HashSet<String> optionalAttendees = new HashSet<String>();
                    List<VProperty> attendeeProperties = this.vCalendar.getFirstVeventProperties("ATTENDEE");
                    if (attendeeProperties != null) {
                        for (VProperty property2 : attendeeProperties) {
                            String attendeeEmail = this.vCalendar.getEmailValue(property2);
                            if (attendeeEmail == null || attendeeEmail.indexOf(64) < 0) continue;
                            if (EwsExchangeSession.this.email.equals(attendeeEmail)) {
                                String ownerPartStat = property2.getParamValue("PARTSTAT");
                                if ("ACCEPTED".equals(ownerPartStat)) {
                                    ownerResponseReply = "AcceptItem";
                                } else if ("DECLINED".equals(ownerPartStat) || "TENTATIVE".equals(ownerPartStat)) {
                                    ownerResponseReply = "TentativelyAcceptItem";
                                }
                            }
                            InternetAddress internetAddress = new InternetAddress(attendeeEmail, property2.getParamValue("CN"));
                            String attendeeRole = property2.getParamValue("ROLE");
                            if ("REQ-PARTICIPANT".equals(attendeeRole)) {
                                requiredAttendees.add(internetAddress.toString());
                                continue;
                            }
                            optionalAttendees.add(internetAddress.toString());
                        }
                    }
                    if ((organizerProperties = this.vCalendar.getFirstVeventProperties("ORGANIZER")) != null && (organizerEmail = this.vCalendar.getEmailValue(property2 = organizerProperties.get(0))) != null && organizerEmail.indexOf(64) >= 0) {
                        updates.add(Field.createFieldUpdate("from", organizerEmail));
                    }
                    if (requiredAttendees.size() > 0) {
                        updates.add(Field.createFieldUpdate("to", StringUtil.join(requiredAttendees, ", ")));
                    }
                    if (optionalAttendees.size() > 0) {
                        updates.add(Field.createFieldUpdate("cc", StringUtil.join(optionalAttendees, ", ")));
                    }
                }
                if ("Exchange2007_SP1".equals(EwsExchangeSession.this.serverVersion) && this.vCalendar.isCdoAllDay()) {
                    updates.add(Field.createFieldUpdate("dtstart", EwsExchangeSession.this.convertCalendarDateToExchange(this.vCalendar.getFirstVeventPropertyValue("DTSTART"))));
                    updates.add(Field.createFieldUpdate("dtend", EwsExchangeSession.this.convertCalendarDateToExchange(this.vCalendar.getFirstVeventPropertyValue("DTEND"))));
                }
                updates.add(Field.createFieldUpdate("busystatus", "BUSY".equals(this.vCalendar.getFirstVeventPropertyValue("X-MICROSOFT-CDO-BUSYSTATUS")) ? "Busy" : "Free"));
                if ("Exchange2007_SP1".equals(EwsExchangeSession.this.serverVersion) && this.vCalendar.isCdoAllDay()) {
                    updates.add(Field.createFieldUpdate("meetingtimezone", this.vCalendar.getVTimezone().getPropertyValue("TZID")));
                }
                newItem.setFieldUpdates(updates);
                createOrUpdateItemMethod = new CreateItemMethod(MessageDisposition.SaveOnly, SendMeetingInvitations.SendToNone, EwsExchangeSession.this.getFolderId(this.folderPath), newItem);
                if (EwsExchangeSession.this.serverVersion != null && EwsExchangeSession.this.serverVersion.startsWith("Exchange201")) {
                    createOrUpdateItemMethod.setTimezoneContext(EwsExchangeSession.this.getVTimezone().getPropertyValue("TZID"));
                }
            }
            EwsExchangeSession.this.executeMethod(createOrUpdateItemMethod);
            itemResult.status = createOrUpdateItemMethod.getStatusCode();
            if (itemResult.status == 200) {
                if (currentItemId == null) {
                    itemResult.status = 201;
                    LOGGER.debug((Object)("Created event " + this.getHref()));
                } else {
                    LOGGER.warn((Object)("Overwritten event " + this.getHref()));
                }
            }
            if (ownerResponseReply != null) {
                EWSMethod.Item responseTypeItem = new EWSMethod.Item();
                responseTypeItem.referenceItemId = new ItemId("ReferenceItemId", createOrUpdateItemMethod.getResponseItem());
                responseTypeItem.type = ownerResponseReply;
                createOrUpdateItemMethod = new CreateItemMethod(MessageDisposition.SaveOnly, SendMeetingInvitations.SendToNone, null, responseTypeItem);
                EwsExchangeSession.this.executeMethod(createOrUpdateItemMethod);
                updates = new ArrayList();
                updates.add(Field.createFieldUpdate("urlcompname", EwsExchangeSession.this.convertItemNameToEML(this.itemName)));
                createOrUpdateItemMethod = new UpdateItemMethod(MessageDisposition.SaveOnly, ConflictResolution.AlwaysOverwrite, SendMeetingInvitationsOrCancellations.SendToNone, new ItemId(createOrUpdateItemMethod.getResponseItem()), updates);
                EwsExchangeSession.this.executeMethod(createOrUpdateItemMethod);
            }
            ItemId newItemId = new ItemId(createOrUpdateItemMethod.getResponseItem());
            GetItemMethod getItemMethod = new GetItemMethod(BaseShape.ID_ONLY, newItemId, false);
            getItemMethod.addAdditionalProperty(Field.get("etag"));
            EwsExchangeSession.this.executeMethod(getItemMethod);
            itemResult.etag = (String)getItemMethod.getResponseItem().get(Field.get("etag").getResponseName());
            return itemResult;
        }

        public byte[] getEventContent() throws IOException {
            byte[] content;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Get event: " + this.itemName));
            }
            try {
                GetItemMethod getItemMethod;
                if ("Task".equals(this.type)) {
                    getItemMethod = new GetItemMethod(BaseShape.ID_ONLY, this.itemId, false);
                    getItemMethod.addAdditionalProperty(Field.get("importance"));
                    getItemMethod.addAdditionalProperty(Field.get("subject"));
                    getItemMethod.addAdditionalProperty(Field.get("created"));
                    getItemMethod.addAdditionalProperty(Field.get("lastmodified"));
                    getItemMethod.addAdditionalProperty(Field.get("calendaruid"));
                    getItemMethod.addAdditionalProperty(Field.get("description"));
                    getItemMethod.addAdditionalProperty(Field.get("percentcomplete"));
                    getItemMethod.addAdditionalProperty(Field.get("taskstatus"));
                    getItemMethod.addAdditionalProperty(Field.get("startdate"));
                    getItemMethod.addAdditionalProperty(Field.get("duedate"));
                    getItemMethod.addAdditionalProperty(Field.get("datecompleted"));
                    getItemMethod.addAdditionalProperty(Field.get("keywords"));
                } else if (!("Message".equals(this.type) || "MeetingCancellation".equals(this.type) || "MeetingResponse".equals(this.type))) {
                    getItemMethod = new GetItemMethod(BaseShape.ID_ONLY, this.itemId, true);
                    getItemMethod.addAdditionalProperty(Field.get("reminderset"));
                    getItemMethod.addAdditionalProperty(Field.get("calendaruid"));
                    getItemMethod.addAdditionalProperty(Field.get("myresponsetype"));
                    getItemMethod.addAdditionalProperty(Field.get("requiredattendees"));
                    getItemMethod.addAdditionalProperty(Field.get("optionalattendees"));
                    getItemMethod.addAdditionalProperty(Field.get("modifiedoccurrences"));
                    getItemMethod.addAdditionalProperty(Field.get("xmozlastack"));
                    getItemMethod.addAdditionalProperty(Field.get("xmozsnoozetime"));
                    getItemMethod.addAdditionalProperty(Field.get("xmozsendinvitations"));
                } else {
                    getItemMethod = new GetItemMethod(BaseShape.ID_ONLY, this.itemId, true);
                }
                EwsExchangeSession.this.executeMethod(getItemMethod);
                if ("Task".equals(this.type)) {
                    VCalendar localVCalendar = new VCalendar();
                    VObject vTodo = new VObject();
                    vTodo.type = "VTODO";
                    localVCalendar.setTimezone(EwsExchangeSession.this.getVTimezone());
                    vTodo.setPropertyValue("LAST-MODIFIED", EwsExchangeSession.this.convertDateFromExchange((String)getItemMethod.getResponseItem().get(Field.get("lastmodified").getResponseName())));
                    vTodo.setPropertyValue("CREATED", EwsExchangeSession.this.convertDateFromExchange((String)getItemMethod.getResponseItem().get(Field.get("created").getResponseName())));
                    String calendarUid = (String)getItemMethod.getResponseItem().get(Field.get("calendaruid").getResponseName());
                    if (calendarUid == null) {
                        calendarUid = this.itemId.id;
                    }
                    vTodo.setPropertyValue("UID", calendarUid);
                    vTodo.setPropertyValue("SUMMARY", (String)getItemMethod.getResponseItem().get(Field.get("subject").getResponseName()));
                    vTodo.setPropertyValue("DESCRIPTION", (String)getItemMethod.getResponseItem().get(Field.get("description").getResponseName()));
                    vTodo.setPropertyValue("PRIORITY", EwsExchangeSession.this.convertPriorityFromExchange((String)getItemMethod.getResponseItem().get(Field.get("importance").getResponseName())));
                    vTodo.setPropertyValue("PERCENT-COMPLETE", (String)getItemMethod.getResponseItem().get(Field.get("percentcomplete").getResponseName()));
                    vTodo.setPropertyValue("STATUS", taskTovTodoStatusMap.get(getItemMethod.getResponseItem().get(Field.get("taskstatus").getResponseName())));
                    vTodo.setPropertyValue("DUE;VALUE=DATE", EwsExchangeSession.this.convertDateFromExchangeToTaskDate((String)getItemMethod.getResponseItem().get(Field.get("duedate").getResponseName())));
                    vTodo.setPropertyValue("DTSTART;VALUE=DATE", EwsExchangeSession.this.convertDateFromExchangeToTaskDate((String)getItemMethod.getResponseItem().get(Field.get("startdate").getResponseName())));
                    vTodo.setPropertyValue("COMPLETED;VALUE=DATE", EwsExchangeSession.this.convertDateFromExchangeToTaskDate((String)getItemMethod.getResponseItem().get(Field.get("datecompleted").getResponseName())));
                    vTodo.setPropertyValue("CATEGORIES", (String)getItemMethod.getResponseItem().get(Field.get("keywords").getResponseName()));
                    localVCalendar.addVObject(vTodo);
                    content = localVCalendar.toString().getBytes("UTF-8");
                } else {
                    content = getItemMethod.getMimeContent();
                    if (content == null) {
                        throw new IOException("empty event body");
                    }
                    if (!"CalendarItem".equals(this.type)) {
                        content = this.getICS((InputStream)new SharedByteArrayInputStream(content));
                    }
                    VCalendar localVCalendar = new VCalendar(content, EwsExchangeSession.this.email, EwsExchangeSession.this.getVTimezone());
                    String calendaruid = (String)getItemMethod.getResponseItem().get(Field.get("calendaruid").getResponseName());
                    if ("Exchange2007_SP1".equals(EwsExchangeSession.this.serverVersion)) {
                        if (!"true".equals(getItemMethod.getResponseItem().get(Field.get("reminderset").getResponseName()))) {
                            localVCalendar.removeVAlarm();
                        }
                        if (calendaruid != null) {
                            localVCalendar.setFirstVeventPropertyValue("UID", calendaruid);
                        }
                    }
                    this.fixAttendees(getItemMethod, localVCalendar.getFirstVevent());
                    List<EWSMethod.Occurrence> occurences = getItemMethod.getResponseItem().getOccurrences();
                    if (occurences != null) {
                        Iterator<VObject> modifiedOccurrencesIterator = localVCalendar.getModifiedOccurrences().iterator();
                        for (EWSMethod.Occurrence occurrence : occurences) {
                            VProperty recurrenceId;
                            if (!modifiedOccurrencesIterator.hasNext()) continue;
                            VObject modifiedOccurrence = modifiedOccurrencesIterator.next();
                            GetItemMethod getOccurrenceMethod = new GetItemMethod(BaseShape.ID_ONLY, occurrence.itemId, false);
                            getOccurrenceMethod.addAdditionalProperty(Field.get("requiredattendees"));
                            getOccurrenceMethod.addAdditionalProperty(Field.get("optionalattendees"));
                            getOccurrenceMethod.addAdditionalProperty(Field.get("modifiedoccurrences"));
                            EwsExchangeSession.this.executeMethod(getOccurrenceMethod);
                            this.fixAttendees(getOccurrenceMethod, modifiedOccurrence);
                            if (calendaruid != null) {
                                modifiedOccurrence.setPropertyValue("UID", calendaruid);
                            }
                            if ((recurrenceId = modifiedOccurrence.getProperty("RECURRENCE-ID")) == null) continue;
                            recurrenceId.removeParam("TZID");
                            recurrenceId.getValues().set(0, EwsExchangeSession.this.convertDateFromExchange(occurrence.originalStart));
                        }
                    }
                    localVCalendar.setFirstVeventPropertyValue("X-MOZ-SEND-INVITATIONS", (String)getItemMethod.getResponseItem().get(Field.get("xmozsendinvitations").getResponseName()));
                    localVCalendar.setFirstVeventPropertyValue("X-MOZ-LASTACK", (String)getItemMethod.getResponseItem().get(Field.get("xmozlastack").getResponseName()));
                    localVCalendar.setFirstVeventPropertyValue("X-MOZ-SNOOZE-TIME", (String)getItemMethod.getResponseItem().get(Field.get("xmozsnoozetime").getResponseName()));
                    content = localVCalendar.toString().getBytes("UTF-8");
                }
            }
            catch (IOException e) {
                throw this.buildHttpException(e);
            }
            catch (MessagingException e) {
                throw this.buildHttpException((Exception)((Object)e));
            }
            return content;
        }

        protected void fixAttendees(GetItemMethod getItemMethod, VObject vEvent) throws EWSException {
            List<EWSMethod.Attendee> attendees;
            if (getItemMethod.getResponseItem() != null && (attendees = getItemMethod.getResponseItem().getAttendees()) != null) {
                for (EWSMethod.Attendee attendee : attendees) {
                    VProperty attendeeProperty = new VProperty("ATTENDEE", "mailto:" + attendee.email);
                    attendeeProperty.addParam("CN", attendee.name);
                    String myResponseType = (String)getItemMethod.getResponseItem().get(Field.get("myresponsetype").getResponseName());
                    if (EwsExchangeSession.this.email.equalsIgnoreCase(attendee.email) && myResponseType != null) {
                        attendeeProperty.addParam("PARTSTAT", EWSMethod.responseTypeToPartstat(myResponseType));
                    } else {
                        attendeeProperty.addParam("PARTSTAT", attendee.partstat);
                    }
                    attendeeProperty.addParam("ROLE", attendee.role);
                    vEvent.addProperty(attendeeProperty);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Contact
    extends ExchangeSession.Contact {
        ItemId itemId;

        protected Contact(EWSMethod.Item response) throws DavMailException {
            this.itemId = new ItemId(response);
            this.permanentUrl = (String)response.get(Field.get("permanenturl").getResponseName());
            this.etag = (String)response.get(Field.get("etag").getResponseName());
            this.displayName = (String)response.get(Field.get("displayname").getResponseName());
            this.itemName = StringUtil.decodeUrlcompname((String)response.get(Field.get("urlcompname").getResponseName()));
            if (this.itemName == null) {
                this.itemName = StringUtil.base64ToUrl(this.itemId.id) + ".EML";
            }
            for (String attributeName : ExchangeSession.CONTACT_ATTRIBUTES) {
                String value = (String)response.get(Field.get(attributeName).getResponseName());
                if (value == null || value.length() <= 0) continue;
                if ("bday".equals(attributeName) || "anniversary".equals(attributeName) || "lastmodified".equals(attributeName) || "datereceived".equals(attributeName)) {
                    value = EwsExchangeSession.this.convertDateFromExchange(value);
                }
                this.put(attributeName, value);
            }
        }

        protected Contact(String folderPath, String itemName, Map<String, String> properties, String etag, String noneMatch) {
            super(folderPath, itemName, properties, etag, noneMatch);
        }

        protected Contact() {
        }

        protected void buildProperties(List<FieldUpdate> updates) {
            for (Map.Entry entry : this.entrySet()) {
                if ("photo".equals(entry.getKey())) {
                    updates.add(Field.createFieldUpdate("haspicture", "true"));
                    continue;
                }
                if (((String)entry.getKey()).startsWith("email") || ((String)entry.getKey()).startsWith("smtpemail") || "fileas".equals(entry.getKey())) continue;
                updates.add(Field.createFieldUpdate((String)entry.getKey(), (String)entry.getValue()));
            }
            if (this.get("fileas") != null) {
                updates.add(Field.createFieldUpdate("fileas", (String)this.get("fileas")));
            }
            IndexedFieldUpdate emailFieldUpdate = null;
            for (Map.Entry entry : this.entrySet()) {
                if (!((String)entry.getKey()).startsWith("smtpemail") || entry.getValue() == null) continue;
                if (emailFieldUpdate == null) {
                    emailFieldUpdate = new IndexedFieldUpdate("EmailAddresses");
                }
                emailFieldUpdate.addFieldValue(Field.createFieldUpdate((String)entry.getKey(), (String)entry.getValue()));
            }
            if (emailFieldUpdate != null) {
                updates.add(emailFieldUpdate);
            }
        }

        public ExchangeSession.ItemResult createOrUpdate() throws IOException {
            EWSMethod createOrUpdateItemMethod;
            String photo = (String)this.get("photo");
            ExchangeSession.ItemResult itemResult = new ExchangeSession.ItemResult();
            String currentEtag = null;
            ItemId currentItemId = null;
            FileAttachment currentFileAttachment = null;
            EWSMethod.Item currentItem = EwsExchangeSession.this.getEwsItem(this.folderPath, this.itemName);
            if (currentItem != null) {
                currentItemId = new ItemId(currentItem);
                currentEtag = (String)currentItem.get(Field.get("etag").getResponseName());
                GetItemMethod getItemMethod = new GetItemMethod(BaseShape.ID_ONLY, currentItemId, false);
                getItemMethod.addAdditionalProperty(Field.get("attachments"));
                EwsExchangeSession.this.executeMethod(getItemMethod);
                EWSMethod.Item item = getItemMethod.getResponseItem();
                if (item != null) {
                    currentFileAttachment = item.getAttachmentByName("ContactPicture.jpg");
                }
            }
            if ("*".equals(this.noneMatch)) {
                if (currentItemId != null) {
                    itemResult.status = 412;
                    return itemResult;
                }
            } else if (!(this.etag == null || currentItemId != null && this.etag.equals(currentEtag))) {
                itemResult.status = 412;
                return itemResult;
            }
            ArrayList<FieldUpdate> properties = new ArrayList<FieldUpdate>();
            if (currentItemId != null) {
                this.buildProperties(properties);
                createOrUpdateItemMethod = new UpdateItemMethod(MessageDisposition.SaveOnly, ConflictResolution.AlwaysOverwrite, SendMeetingInvitationsOrCancellations.SendToNone, currentItemId, properties);
            } else {
                EWSMethod.Item newItem = new EWSMethod.Item();
                newItem.type = "Contact";
                properties.add(Field.createFieldUpdate("urlcompname", EwsExchangeSession.this.convertItemNameToEML(this.itemName)));
                this.buildProperties(properties);
                newItem.setFieldUpdates(properties);
                createOrUpdateItemMethod = new CreateItemMethod(MessageDisposition.SaveOnly, EwsExchangeSession.this.getFolderId(this.folderPath), newItem);
            }
            EwsExchangeSession.this.executeMethod(createOrUpdateItemMethod);
            itemResult.status = createOrUpdateItemMethod.getStatusCode();
            if (itemResult.status == 200) {
                if (this.etag == null) {
                    itemResult.status = 201;
                    LOGGER.debug((Object)("Created contact " + this.getHref()));
                } else {
                    LOGGER.debug((Object)("Updated contact " + this.getHref()));
                }
            } else {
                return itemResult;
            }
            ItemId newItemId = new ItemId(createOrUpdateItemMethod.getResponseItem());
            if (!"Exchange2007_SP1".equals(EwsExchangeSession.this.serverVersion)) {
                if (currentFileAttachment != null) {
                    DeleteAttachmentMethod deleteAttachmentMethod = new DeleteAttachmentMethod(currentFileAttachment.attachmentId);
                    EwsExchangeSession.this.executeMethod(deleteAttachmentMethod);
                }
                if (photo != null) {
                    byte[] resizedImageBytes = IOUtil.resizeImage(IOUtil.decodeBase64(photo), 90);
                    FileAttachment attachment = new FileAttachment("ContactPicture.jpg", "image/jpeg", IOUtil.encodeBase64AsString(resizedImageBytes));
                    attachment.setIsContactPhoto(true);
                    CreateAttachmentMethod createAttachmentMethod = new CreateAttachmentMethod(newItemId, attachment);
                    EwsExchangeSession.this.executeMethod(createAttachmentMethod);
                }
            }
            GetItemMethod getItemMethod = new GetItemMethod(BaseShape.ID_ONLY, newItemId, false);
            getItemMethod.addAdditionalProperty(Field.get("etag"));
            EwsExchangeSession.this.executeMethod(getItemMethod);
            itemResult.etag = (String)getItemMethod.getResponseItem().get(Field.get("etag").getResponseName());
            return itemResult;
        }
    }

    protected static class IsNullCondition
    implements ExchangeSession.Condition,
    SearchExpression {
        protected final String attributeName;

        protected IsNullCondition(String attributeName) {
            this.attributeName = attributeName;
        }

        public void appendTo(StringBuilder buffer) {
            buffer.append("<t:Not><t:Exists>");
            Field.get(this.attributeName).appendTo(buffer);
            buffer.append("</t:Exists></t:Not>");
        }

        public boolean isEmpty() {
            return false;
        }

        public boolean isMatch(ExchangeSession.Contact contact) {
            String actualValue = (String)contact.get(this.attributeName);
            return actualValue == null;
        }
    }

    protected static class HeaderCondition
    extends AttributeCondition {
        protected HeaderCondition(String attributeName, String value) {
            super(attributeName, ExchangeSession.Operator.Contains, value);
            this.containmentMode = ContainmentMode.Substring;
            this.containmentComparison = ContainmentComparison.IgnoreCase;
        }

        protected FieldURI getFieldURI() {
            return new ExtendedFieldURI(ExtendedFieldURI.DistinguishedPropertySetType.InternetHeaders, this.attributeName);
        }
    }

    protected static class AttributeCondition
    extends ExchangeSession.AttributeCondition
    implements SearchExpression {
        protected ContainmentMode containmentMode;
        protected ContainmentComparison containmentComparison;

        protected AttributeCondition(String attributeName, ExchangeSession.Operator operator, String value) {
            super(attributeName, operator, value);
        }

        protected AttributeCondition(String attributeName, ExchangeSession.Operator operator, String value, ContainmentMode containmentMode, ContainmentComparison containmentComparison) {
            super(attributeName, operator, value);
            this.containmentMode = containmentMode;
            this.containmentComparison = containmentComparison;
        }

        protected FieldURI getFieldURI() {
            FieldURI fieldURI = Field.get(this.attributeName);
            if (fieldURI == null) {
                throw new IllegalArgumentException("Unknown field: " + this.attributeName);
            }
            return fieldURI;
        }

        protected ExchangeSession.Operator getOperator() {
            return this.operator;
        }

        public void appendTo(StringBuilder buffer) {
            buffer.append("<t:").append(this.operator.toString());
            if (this.containmentMode != null) {
                this.containmentMode.appendTo(buffer);
            }
            if (this.containmentComparison != null) {
                this.containmentComparison.appendTo(buffer);
            }
            buffer.append('>');
            FieldURI fieldURI = this.getFieldURI();
            fieldURI.appendTo(buffer);
            if (this.operator != ExchangeSession.Operator.Contains) {
                buffer.append("<t:FieldURIOrConstant>");
            }
            buffer.append("<t:Constant Value=\"");
            if (fieldURI instanceof ExtendedFieldURI && "0x10f3".equals(((ExtendedFieldURI)fieldURI).propertyTag)) {
                buffer.append(StringUtil.xmlEncodeAttribute(StringUtil.encodeUrlcompname(this.value)));
            } else if (fieldURI instanceof ExtendedFieldURI && ((ExtendedFieldURI)fieldURI).propertyType == ExtendedFieldURI.PropertyType.Integer) {
                try {
                    Integer.parseInt(this.value);
                    buffer.append(this.value);
                }
                catch (NumberFormatException e) {
                    buffer.append('0');
                }
            } else {
                buffer.append(StringUtil.xmlEncodeAttribute(this.value));
            }
            buffer.append("\"/>");
            if (this.operator != ExchangeSession.Operator.Contains) {
                buffer.append("</t:FieldURIOrConstant>");
            }
            buffer.append("</t:").append(this.operator.toString()).append('>');
        }

        public boolean isMatch(ExchangeSession.Contact contact) {
            String lowerCaseValue = this.value.toLowerCase();
            String actualValue = (String)contact.get(this.attributeName);
            if (actualValue == null) {
                return false;
            }
            actualValue = actualValue.toLowerCase();
            if (this.operator == ExchangeSession.Operator.IsEqualTo) {
                return lowerCaseValue.equals(actualValue);
            }
            return this.operator == ExchangeSession.Operator.Contains && (this.containmentMode.equals(ContainmentMode.Substring) && actualValue.contains(lowerCaseValue) || this.containmentMode.equals(ContainmentMode.Prefixed) && actualValue.startsWith(lowerCaseValue));
        }
    }

    protected static class NotCondition
    extends ExchangeSession.NotCondition
    implements SearchExpression {
        protected NotCondition(ExchangeSession.Condition condition) {
            super(condition);
        }

        public void appendTo(StringBuilder buffer) {
            buffer.append("<t:Not>");
            this.condition.appendTo(buffer);
            buffer.append("</t:Not>");
        }
    }

    protected static class MultiCondition
    extends ExchangeSession.MultiCondition
    implements SearchExpression {
        protected MultiCondition(ExchangeSession.Operator operator, ExchangeSession.Condition ... condition) {
            super(operator, condition);
        }

        public void appendTo(StringBuilder buffer) {
            int actualConditionCount = 0;
            for (ExchangeSession.Condition condition : this.conditions) {
                if (condition.isEmpty()) continue;
                ++actualConditionCount;
            }
            if (actualConditionCount > 0) {
                if (actualConditionCount > 1) {
                    buffer.append("<t:").append(this.operator.toString()).append('>');
                }
                for (ExchangeSession.Condition condition : this.conditions) {
                    condition.appendTo(buffer);
                }
                if (actualConditionCount > 1) {
                    buffer.append("</t:").append(this.operator.toString()).append('>');
                }
            }
        }
    }

    class Message
    extends ExchangeSession.Message {
        ItemId itemId;

        Message() {
        }

        public String getPermanentId() {
            return this.itemId.id;
        }

        protected InputStream getMimeHeaders() {
            ByteArrayInputStream result = null;
            try {
                GetItemMethod getItemMethod = new GetItemMethod(BaseShape.ID_ONLY, this.itemId, false);
                getItemMethod.addAdditionalProperty(Field.get("messageheaders"));
                getItemMethod.addAdditionalProperty(Field.get("from"));
                EwsExchangeSession.this.executeMethod(getItemMethod);
                EWSMethod.Item item = getItemMethod.getResponseItem();
                String messageHeaders = (String)item.get(Field.get("messageheaders").getResponseName());
                if (messageHeaders != null && messageHeaders.toLowerCase().contains("message-id:")) {
                    if (!messageHeaders.contains("From:")) {
                        String from = (String)item.get(Field.get("from").getResponseName());
                        messageHeaders = "From: " + from + '\n' + messageHeaders;
                    }
                    result = new ByteArrayInputStream(messageHeaders.getBytes("UTF-8"));
                }
            }
            catch (Exception e) {
                LOGGER.warn((Object)e.getMessage());
            }
            return result;
        }
    }

    protected static class AutoDiscoverMethod
    extends PostMethod {
        String ewsUrl;

        AutoDiscoverMethod(String autodiscoverHost, String userEmail) throws IOException {
            super("https://" + autodiscoverHost + "/autodiscover/autodiscover.xml");
            this.setAutoDiscoverRequestEntity(userEmail);
        }

        AutoDiscoverMethod(String userEmail) throws IOException {
            super("/autodiscover/autodiscover.xml");
            this.setAutoDiscoverRequestEntity(userEmail);
        }

        void setAutoDiscoverRequestEntity(String userEmail) throws IOException {
            String body = "<Autodiscover xmlns=\"http://schemas.microsoft.com/exchange/autodiscover/outlook/requestschema/2006\"><Request><EMailAddress>" + userEmail + "</EMailAddress>" + "<AcceptableResponseSchema>http://schemas.microsoft.com/exchange/autodiscover/outlook/responseschema/2006a</AcceptableResponseSchema>" + "</Request>" + "</Autodiscover>";
            this.setRequestEntity((RequestEntity)new StringRequestEntity(body, "text/xml", "UTF-8"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void processResponseBody(HttpState httpState, HttpConnection httpConnection) {
            Header contentTypeHeader = this.getResponseHeader("Content-Type");
            if (contentTypeHeader != null && ("text/xml; charset=utf-8".equals(contentTypeHeader.getValue()) || "text/html; charset=utf-8".equals(contentTypeHeader.getValue()))) {
                BufferedReader autodiscoverReader = null;
                try {
                    String line;
                    autodiscoverReader = new BufferedReader(new InputStreamReader(this.getResponseBodyAsStream(), "UTF-8"));
                    while ((line = autodiscoverReader.readLine()) != null && !line.contains("<EwsUrl>") && !line.contains("</EwsUrl>")) {
                    }
                    if (line != null) {
                        this.ewsUrl = line.substring(line.indexOf("<EwsUrl>") + 8, line.indexOf("</EwsUrl>"));
                    }
                }
                catch (IOException e) {
                    LOGGER.debug((Object)e);
                }
                finally {
                    if (autodiscoverReader != null) {
                        try {
                            autodiscoverReader.close();
                        }
                        catch (IOException e) {
                            LOGGER.debug((Object)e);
                        }
                    }
                }
            }
        }
    }

    protected static class FolderPath {
        protected final String parentPath;
        protected final String folderName;

        protected FolderPath(String folderPath) {
            int slashIndex = folderPath.lastIndexOf(47);
            if (slashIndex < 0) {
                this.parentPath = "";
                this.folderName = folderPath;
            } else {
                this.parentPath = folderPath.substring(0, slashIndex);
                this.folderName = folderPath.substring(slashIndex + 1);
            }
        }
    }

    protected class Folder
    extends ExchangeSession.Folder {
        public FolderId folderId;

        protected Folder() {
        }
    }
}

