/*
 * Decompiled with CFR 0.152.
 */
package davmail.exchange.ews;

import davmail.exchange.ews.FieldURI;
import davmail.util.StringUtil;

public class UnindexedFieldURI
implements FieldURI {
    protected final String fieldURI;
    protected final String fieldName;

    public UnindexedFieldURI(String fieldURI) {
        this.fieldURI = fieldURI;
        int colonIndex = fieldURI.indexOf(58);
        this.fieldName = colonIndex < 0 ? fieldURI : fieldURI.substring(colonIndex + 1);
    }

    public void appendTo(StringBuilder buffer) {
        buffer.append("<t:FieldURI FieldURI=\"").append(this.fieldURI).append("\"/>");
    }

    public void appendValue(StringBuilder buffer, String itemType, String value) {
        if (this.fieldURI.startsWith("message") && itemType != null) {
            itemType = "Message";
        } else if (this.fieldURI.startsWith("calendar") && itemType != null) {
            itemType = "CalendarItem";
        } else if (this.fieldURI.startsWith("task") && itemType != null) {
            itemType = "Task";
        } else if (this.fieldURI.startsWith("contacts") && itemType != null) {
            itemType = "Contact";
        }
        if (itemType != null) {
            this.appendTo(buffer);
            buffer.append("<t:");
            buffer.append(itemType);
            buffer.append('>');
        }
        if ("MeetingTimeZone".equals(this.fieldName)) {
            buffer.append("<t:MeetingTimeZone TimeZoneName=\"");
            buffer.append(StringUtil.xmlEncodeAttribute(value));
            buffer.append("\"></t:MeetingTimeZone>");
        } else if ("StartTimeZone".equals(this.fieldName)) {
            buffer.append("<t:StartTimeZone Id=\"");
            buffer.append(StringUtil.xmlEncodeAttribute(value));
            buffer.append("\"></t:StartTimeZone>");
        } else {
            buffer.append("<t:");
            buffer.append(this.fieldName);
            buffer.append('>');
            buffer.append(StringUtil.xmlEncodeAttribute(value));
            buffer.append("</t:");
            buffer.append(this.fieldName);
            buffer.append('>');
        }
        if (itemType != null) {
            buffer.append("</t:");
            buffer.append(itemType);
            buffer.append('>');
        }
    }

    public String getResponseName() {
        return this.fieldName;
    }
}

