/*
 * Decompiled with CFR 0.152.
 */
package davmail.http;

import davmail.BundleMessage;
import davmail.Settings;
import davmail.exception.DavMailAuthenticationException;
import davmail.exception.DavMailException;
import davmail.exception.HttpForbiddenException;
import davmail.exception.HttpNotFoundException;
import davmail.exception.HttpPreconditionFailedException;
import davmail.exception.HttpServerErrorException;
import davmail.exception.LoginTimeoutException;
import davmail.exchange.dav.ExchangeDavMethod;
import davmail.exchange.dav.ExchangeSearchMethod;
import davmail.http.DavMailCookieSpec;
import davmail.http.LenientBasicScheme;
import davmail.http.NTLMv2Scheme;
import davmail.http.SpNegoScheme;
import davmail.ui.tray.DavGatewayTray;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.auth.AuthPolicy;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.cookie.CookiePolicy;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.util.IdleConnectionTimeoutThread;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.client.methods.CopyMethod;
import org.apache.jackrabbit.webdav.client.methods.DavMethodBase;
import org.apache.jackrabbit.webdav.client.methods.MoveMethod;
import org.apache.jackrabbit.webdav.client.methods.PropFindMethod;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DavGatewayHttpClientFacade {
    static final Logger LOGGER = Logger.getLogger((String)"davmail.http.DavGatewayHttpClientFacade");
    static final String IE_USER_AGENT = "Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.1; Trident/4.0)";
    static final int MAX_REDIRECTS = 10;
    static final Object LOCK = new Object();
    private static boolean needNTLM;
    static final long ONE_MINUTE = 60000L;
    private static IdleConnectionTimeoutThread httpConnectionManagerThread;

    private DavGatewayHttpClientFacade() {
    }

    private static HttpClient getBaseInstance() {
        HttpClient httpClient = new HttpClient();
        httpClient.getParams().setParameter("http.useragent", (Object)IE_USER_AGENT);
        httpClient.getParams().setParameter("http.protocol.max-redirects", (Object)10);
        httpClient.getParams().setCookiePolicy("DavMailCookieSpec");
        return httpClient;
    }

    public static HttpClient getInstance(String url) throws DavMailException {
        HttpClient httpClient = DavGatewayHttpClientFacade.getBaseInstance();
        DavGatewayHttpClientFacade.configureClient(httpClient, url);
        return httpClient;
    }

    public static void setCredentials(HttpClient httpClient, String userName, String password) {
        AuthScope authScope = new AuthScope(null, -1);
        int backSlashIndex = userName.indexOf(92);
        if (needNTLM && backSlashIndex >= 0) {
            String domain = userName.substring(0, backSlashIndex);
            userName = userName.substring(backSlashIndex + 1);
            httpClient.getState().setCredentials(authScope, (Credentials)new NTCredentials(userName, password, "UNKNOWN", domain));
        } else {
            httpClient.getState().setCredentials(authScope, (Credentials)new NTCredentials(userName, password, "UNKNOWN", ""));
        }
    }

    public static void setClientHost(HttpClient httpClient, String url) throws DavMailException {
        try {
            HostConfiguration hostConfig = httpClient.getHostConfiguration();
            URI httpURI = new URI(url, true);
            hostConfig.setHost(httpURI);
        }
        catch (URIException e) {
            throw new DavMailException("LOG_INVALID_URL", url);
        }
    }

    protected static boolean isNoProxyFor(java.net.URI uri) {
        String noProxyFor = Settings.getProperty("davmail.noProxyFor");
        if (noProxyFor != null) {
            String[] domains;
            String urihost = uri.getHost().toLowerCase();
            for (String domain : domains = noProxyFor.toLowerCase().split(",\\s*")) {
                if (!urihost.endsWith(domain)) continue;
                return true;
            }
        }
        return false;
    }

    public static void configureClient(HttpClient httpClient, String url) throws DavMailException {
        ArrayList<String> authPrefs;
        DavGatewayHttpClientFacade.setClientHost(httpClient, url);
        if (!needNTLM && url.toLowerCase().endsWith("/ews/exchange.asmx")) {
            needNTLM = true;
        }
        if (Settings.getBooleanProperty("davmail.enableKerberos", false)) {
            AuthPolicy.registerAuthScheme((String)"Negotiate", SpNegoScheme.class);
            authPrefs = new ArrayList();
            authPrefs.add("Negotiate");
            httpClient.getParams().setParameter("http.auth.scheme-priority", authPrefs);
        } else if (!needNTLM) {
            authPrefs = new ArrayList<String>();
            authPrefs.add("Digest");
            authPrefs.add("Basic");
            httpClient.getParams().setParameter("http.auth.scheme-priority", authPrefs);
        }
        boolean enableProxy = Settings.getBooleanProperty("davmail.enableProxy");
        boolean useSystemProxies = Settings.getBooleanProperty("davmail.useSystemProxies", Boolean.FALSE);
        String proxyHost = null;
        int proxyPort = 0;
        String proxyUser = null;
        String proxyPassword = null;
        try {
            java.net.URI uri = new java.net.URI(url);
            if (DavGatewayHttpClientFacade.isNoProxyFor(uri)) {
                LOGGER.debug((Object)("no proxy for " + uri.getHost()));
            } else if (useSystemProxies) {
                System.setProperty("java.net.useSystemProxies", "true");
                List<Proxy> proxyList = DavGatewayHttpClientFacade.getProxyForURI(uri);
                if (!proxyList.isEmpty() && proxyList.get(0).address() != null) {
                    InetSocketAddress inetSocketAddress = (InetSocketAddress)proxyList.get(0).address();
                    proxyHost = inetSocketAddress.getHostName();
                    proxyPort = inetSocketAddress.getPort();
                    proxyUser = Settings.getProperty("davmail.proxyUser");
                    proxyPassword = Settings.getProperty("davmail.proxyPassword");
                }
            } else if (enableProxy) {
                proxyHost = Settings.getProperty("davmail.proxyHost");
                proxyPort = Settings.getIntProperty("davmail.proxyPort");
                proxyUser = Settings.getProperty("davmail.proxyUser");
                proxyPassword = Settings.getProperty("davmail.proxyPassword");
            }
        }
        catch (URISyntaxException e) {
            throw new DavMailException("LOG_INVALID_URL", url);
        }
        if (proxyHost != null && proxyHost.length() > 0) {
            httpClient.getHostConfiguration().setProxy(proxyHost, proxyPort);
            if (proxyUser != null && proxyUser.length() > 0) {
                AuthScope authScope = new AuthScope(proxyHost, proxyPort, AuthScope.ANY_REALM);
                int backslashindex = proxyUser.indexOf(92);
                if (backslashindex > 0) {
                    httpClient.getState().setProxyCredentials(authScope, (Credentials)new NTCredentials(proxyUser.substring(backslashindex + 1), proxyPassword, "UNKNOWN", proxyUser.substring(0, backslashindex)));
                } else {
                    httpClient.getState().setProxyCredentials(authScope, (Credentials)new NTCredentials(proxyUser, proxyPassword, "UNKNOWN", ""));
                }
            }
        }
    }

    private static List<Proxy> getProxyForURI(java.net.URI uri) {
        LOGGER.debug((Object)"get Default proxy selector");
        ProxySelector proxySelector = ProxySelector.getDefault();
        LOGGER.debug((Object)("getProxyForURI(" + uri + ')'));
        List<Proxy> proxies = proxySelector.select(uri);
        LOGGER.debug((Object)("got system proxies:" + proxies));
        return proxies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getHttpStatus(HttpClient httpClient, String url) {
        int status = 0;
        GetMethod testMethod = new GetMethod(url);
        testMethod.setDoAuthentication(false);
        try {
            status = httpClient.executeMethod((HttpMethod)testMethod);
        }
        catch (IOException e) {
            LOGGER.warn((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            testMethod.releaseConnection();
        }
        return status;
    }

    public static boolean isRedirect(int status) {
        return status == 301 || status == 302 || status == 303 || status == 307;
    }

    public static HttpMethod executeFollowRedirects(HttpClient httpClient, String url) throws IOException {
        GetMethod method = new GetMethod(url);
        method.setFollowRedirects(false);
        return DavGatewayHttpClientFacade.executeFollowRedirects(httpClient, (HttpMethod)method);
    }

    private static int checkNTLM(HttpClient httpClient, HttpMethod currentMethod) throws IOException {
        int status = currentMethod.getStatusCode();
        if ((status == 401 || status == 407) && DavGatewayHttpClientFacade.acceptsNTLMOnly(currentMethod) && !DavGatewayHttpClientFacade.hasNTLMorNegotiate(httpClient)) {
            LOGGER.debug((Object)("Received " + status + " unauthorized at " + currentMethod.getURI() + ", retrying with NTLM"));
            DavGatewayHttpClientFacade.resetMethod(currentMethod);
            DavGatewayHttpClientFacade.addNTLM(httpClient);
            status = httpClient.executeMethod(currentMethod);
        }
        return status;
    }

    private static String getJavascriptRedirectUrl(HttpMethod method) throws IOException {
        Pattern p;
        Matcher m;
        String responseBody = method.getResponseBodyAsString();
        String jsRedirectionUrl = null;
        if (responseBody.indexOf("javascript:go_url()") > 0 && (m = (p = Pattern.compile("go_url\\(\\)[^{]+\\{[^l]+location.replace\\(\"(/[^\"]+)\"\\)")).matcher(responseBody)).find()) {
            jsRedirectionUrl = m.group(1);
        }
        return jsRedirectionUrl;
    }

    private static String getLocationValue(HttpMethod method) throws URIException {
        String locationValue = null;
        Header location = method.getResponseHeader("Location");
        if (location != null && DavGatewayHttpClientFacade.isRedirect(method.getStatusCode())) {
            locationValue = location.getValue();
            if (locationValue.indexOf(34) >= 0) {
                locationValue = URIUtil.encodePath((String)locationValue);
            }
            if (locationValue.startsWith("./")) {
                locationValue = locationValue.substring(1);
            }
        }
        return locationValue;
    }

    public static HttpMethod executeFollowRedirects(HttpClient httpClient, HttpMethod method) throws IOException {
        HttpMethod currentMethod = method;
        try {
            DavGatewayTray.debug(new BundleMessage("LOG_EXECUTE_FOLLOW_REDIRECTS", currentMethod.getURI()));
            httpClient.executeMethod(currentMethod);
            DavGatewayHttpClientFacade.checkNTLM(httpClient, currentMethod);
            String locationValue = DavGatewayHttpClientFacade.getLocationValue(currentMethod);
            if (locationValue == null) {
                locationValue = DavGatewayHttpClientFacade.getJavascriptRedirectUrl(currentMethod);
            }
            int redirectCount = 0;
            while (redirectCount++ < 10 && locationValue != null) {
                currentMethod.releaseConnection();
                currentMethod = new GetMethod(locationValue);
                currentMethod.setFollowRedirects(false);
                DavGatewayTray.debug(new BundleMessage("LOG_EXECUTE_FOLLOW_REDIRECTS_COUNT", currentMethod.getURI(), redirectCount));
                httpClient.executeMethod(currentMethod);
                DavGatewayHttpClientFacade.checkNTLM(httpClient, currentMethod);
                locationValue = DavGatewayHttpClientFacade.getLocationValue(currentMethod);
            }
            if (locationValue != null) {
                currentMethod.releaseConnection();
                throw new HttpException("Maximum redirections reached");
            }
        }
        catch (IOException e) {
            currentMethod.releaseConnection();
            throw e;
        }
        return currentMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeNoRedirect(HttpClient httpClient, HttpMethod method) throws IOException {
        int status;
        try {
            status = httpClient.executeMethod(method);
            if ((status == 401 || status == 407) && DavGatewayHttpClientFacade.acceptsNTLMOnly(method) && !DavGatewayHttpClientFacade.hasNTLMorNegotiate(httpClient)) {
                LOGGER.debug((Object)("Received " + status + " unauthorized at " + method.getURI() + ", retrying with NTLM"));
                DavGatewayHttpClientFacade.resetMethod(method);
                DavGatewayHttpClientFacade.addNTLM(httpClient);
                status = httpClient.executeMethod(method);
            }
        }
        finally {
            method.releaseConnection();
        }
        return status;
    }

    public static MultiStatusResponse[] executeSearchMethod(HttpClient httpClient, String path, String searchRequest, int maxCount) throws IOException {
        ExchangeSearchMethod searchMethod = new ExchangeSearchMethod(path, searchRequest);
        if (maxCount > 0) {
            searchMethod.addRequestHeader("Range", "rows=0-" + (maxCount - 1));
        }
        return DavGatewayHttpClientFacade.executeMethod(httpClient, searchMethod);
    }

    public static MultiStatusResponse[] executePropFindMethod(HttpClient httpClient, String path, int depth, DavPropertyNameSet properties) throws IOException {
        PropFindMethod propFindMethod = new PropFindMethod(path, properties, depth);
        return DavGatewayHttpClientFacade.executeMethod(httpClient, (DavMethodBase)propFindMethod);
    }

    public static int executeDeleteMethod(HttpClient httpClient, String path) throws IOException {
        DeleteMethod deleteMethod = new DeleteMethod(path);
        deleteMethod.setFollowRedirects(false);
        int status = DavGatewayHttpClientFacade.executeHttpMethod(httpClient, (HttpMethod)deleteMethod);
        if (status != 200 && status != 404) {
            throw DavGatewayHttpClientFacade.buildHttpException((HttpMethod)deleteMethod);
        }
        return status;
    }

    public static MultiStatusResponse[] executeMethod(HttpClient httpClient, DavMethodBase method) throws IOException {
        MultiStatusResponse[] responses = null;
        try {
            int status = httpClient.executeMethod((HttpMethod)method);
            if (DavGatewayHttpClientFacade.isRedirect(status)) {
                method.releaseConnection();
                URI targetUri = new URI(method.getResponseHeader("Location").getValue(), true);
                DavGatewayHttpClientFacade.checkExpiredSession(targetUri.getQuery());
                method.setURI(targetUri);
                status = httpClient.executeMethod((HttpMethod)method);
            }
            if (status != 207) {
                throw DavGatewayHttpClientFacade.buildHttpException((HttpMethod)method);
            }
            responses = method.getResponseBodyAsMultiStatus().getResponses();
        }
        catch (DavException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            method.releaseConnection();
        }
        return responses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MultiStatusResponse[] executeMethod(HttpClient httpClient, ExchangeDavMethod method) throws IOException {
        MultiStatusResponse[] responses = null;
        try {
            int status = httpClient.executeMethod((HttpMethod)method);
            if (DavGatewayHttpClientFacade.isRedirect(status)) {
                method.releaseConnection();
                URI targetUri = new URI(method.getResponseHeader("Location").getValue(), true);
                DavGatewayHttpClientFacade.checkExpiredSession(targetUri.getQuery());
                method.setURI(targetUri);
                status = httpClient.executeMethod((HttpMethod)method);
            }
            if (status != 207) {
                throw DavGatewayHttpClientFacade.buildHttpException((HttpMethod)method);
            }
            responses = method.getResponses();
        }
        finally {
            method.releaseConnection();
        }
        return responses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeHttpMethod(HttpClient httpClient, HttpMethod method) throws IOException {
        int status = 0;
        try {
            status = httpClient.executeMethod(method);
        }
        finally {
            method.releaseConnection();
        }
        return status;
    }

    public static boolean hasNTLMorNegotiate(HttpClient httpClient) {
        Object authPrefs = httpClient.getParams().getParameter("http.auth.scheme-priority");
        return authPrefs == null || authPrefs instanceof List && (((Collection)authPrefs).contains("NTLM") || ((Collection)authPrefs).contains("Negotiate"));
    }

    public static void addNTLM(HttpClient httpClient) {
        httpClient.getParams().setParameter("http.authentication.preemptive", (Object)false);
        AuthPolicy.registerAuthScheme((String)"NTLM", NTLMv2Scheme.class);
        ArrayList<String> authPrefs = new ArrayList<String>();
        authPrefs.add("NTLM");
        authPrefs.add("Digest");
        authPrefs.add("Basic");
        httpClient.getParams().setParameter("http.auth.scheme-priority", authPrefs);
        needNTLM = true;
        AuthScope authScope = new AuthScope(null, -1);
        NTCredentials credentials = (NTCredentials)httpClient.getState().getCredentials(authScope);
        DavGatewayHttpClientFacade.setCredentials(httpClient, credentials.getUserName(), credentials.getPassword());
    }

    public static boolean acceptsNTLMOnly(HttpMethod getMethod) {
        HeaderElement[] headerElements;
        Header authenticateHeader = null;
        if (getMethod.getStatusCode() == 401) {
            authenticateHeader = getMethod.getResponseHeader("WWW-Authenticate");
        } else if (getMethod.getStatusCode() == 407) {
            authenticateHeader = getMethod.getResponseHeader("Proxy-Authenticate");
        }
        if (authenticateHeader == null) {
            return false;
        }
        boolean acceptBasic = false;
        boolean acceptNTLM = false;
        for (HeaderElement headerElement : headerElements = authenticateHeader.getElements()) {
            if ("NTLM".equalsIgnoreCase(headerElement.getName())) {
                acceptNTLM = true;
            }
            if (!"Basic realm".equalsIgnoreCase(headerElement.getName())) continue;
            acceptBasic = true;
        }
        return acceptNTLM && !acceptBasic;
    }

    public static int executeTestMethod(HttpClient httpClient, GetMethod method) throws IOException {
        method.setFollowRedirects(false);
        int status = httpClient.executeMethod((HttpMethod)method);
        if (status == 407 && DavGatewayHttpClientFacade.acceptsNTLMOnly((HttpMethod)method) && !DavGatewayHttpClientFacade.hasNTLMorNegotiate(httpClient)) {
            DavGatewayHttpClientFacade.resetMethod((HttpMethod)method);
            LOGGER.debug((Object)("Received " + status + " unauthorized at " + method.getURI() + ", retrying with NTLM"));
            DavGatewayHttpClientFacade.addNTLM(httpClient);
            status = httpClient.executeMethod((HttpMethod)method);
        }
        return status;
    }

    public static void executeGetMethod(HttpClient httpClient, GetMethod method, boolean followRedirects) throws IOException {
        method.setFollowRedirects(followRedirects);
        int status = httpClient.executeMethod((HttpMethod)method);
        if ((status == 401 || status == 407) && DavGatewayHttpClientFacade.acceptsNTLMOnly((HttpMethod)method) && !DavGatewayHttpClientFacade.hasNTLMorNegotiate(httpClient)) {
            DavGatewayHttpClientFacade.resetMethod((HttpMethod)method);
            LOGGER.debug((Object)("Received " + status + " unauthorized at " + method.getURI() + ", retrying with NTLM"));
            DavGatewayHttpClientFacade.addNTLM(httpClient);
            status = httpClient.executeMethod((HttpMethod)method);
        }
        if (status != 200 && (followRedirects || !DavGatewayHttpClientFacade.isRedirect(status))) {
            LOGGER.warn((Object)("GET failed with status " + status + " at " + method.getURI()));
            if (status != 404 && status != 403) {
                LOGGER.warn((Object)method.getResponseBodyAsString());
            }
            throw DavGatewayHttpClientFacade.buildHttpException((HttpMethod)method);
        }
        if (followRedirects) {
            String queryString = method.getQueryString();
            DavGatewayHttpClientFacade.checkExpiredSession(queryString);
        }
    }

    private static void resetMethod(HttpMethod method) {
        method.releaseConnection();
        method.getHostAuthState().invalidate();
        method.getProxyAuthState().invalidate();
    }

    private static void checkExpiredSession(String queryString) throws DavMailAuthenticationException {
        if (queryString != null && (queryString.contains("reason=2") || queryString.contains("reason=0"))) {
            LOGGER.warn((Object)"Request failed, session expired");
            throw new DavMailAuthenticationException("EXCEPTION_SESSION_EXPIRED");
        }
    }

    public static HttpException buildHttpException(HttpMethod method) {
        int status = method.getStatusCode();
        StringBuilder message = new StringBuilder();
        message.append(status).append(' ').append(method.getStatusText());
        try {
            message.append(" at ").append(method.getURI().getURI());
            if (method instanceof CopyMethod || method instanceof MoveMethod) {
                message.append(" to ").append(method.getRequestHeader("Destination"));
            }
        }
        catch (URIException e) {
            message.append(method.getPath());
        }
        if (status == 440) {
            return new LoginTimeoutException(message.toString());
        }
        if (status == 403) {
            return new HttpForbiddenException(message.toString());
        }
        if (status == 404) {
            return new HttpNotFoundException(message.toString());
        }
        if (status == 412) {
            return new HttpPreconditionFailedException(message.toString());
        }
        if (status == 500) {
            return new HttpServerErrorException(message.toString());
        }
        return new HttpException(message.toString());
    }

    public static boolean isGzipEncoded(HttpMethod method) {
        Header[] contentEncodingHeaders = method.getResponseHeaders("Content-Encoding");
        if (contentEncodingHeaders != null) {
            for (Header header : contentEncodingHeaders) {
                if (!"gzip".equals(header.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop() {
        Object object = LOCK;
        synchronized (object) {
            if (httpConnectionManagerThread != null) {
                httpConnectionManagerThread.interrupt();
                httpConnectionManagerThread = null;
            }
            MultiThreadedHttpConnectionManager.shutdownAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createMultiThreadedHttpConnectionManager(HttpClient httpClient) {
        MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        connectionManager.getParams().setDefaultMaxConnectionsPerHost(Settings.getIntProperty("davmail.exchange.maxConnections", 100));
        connectionManager.getParams().setConnectionTimeout(10000);
        connectionManager.getParams().setSoTimeout(120000);
        Object object = LOCK;
        synchronized (object) {
            httpConnectionManagerThread.addConnectionManager((HttpConnectionManager)connectionManager);
        }
        httpClient.setHttpConnectionManager((HttpConnectionManager)connectionManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start() {
        Object object = LOCK;
        synchronized (object) {
            if (httpConnectionManagerThread == null) {
                httpConnectionManagerThread = new IdleConnectionTimeoutThread();
                httpConnectionManagerThread.setName(IdleConnectionTimeoutThread.class.getSimpleName());
                httpConnectionManagerThread.setConnectionTimeout(60000L);
                httpConnectionManagerThread.setTimeoutInterval(60000L);
                httpConnectionManagerThread.start();
            }
        }
    }

    static {
        System.setProperty("sun.security.ssl.allowUnsafeRenegotiation", "true");
        DavGatewayHttpClientFacade.start();
        CookiePolicy.registerCookieSpec((String)"DavMailCookieSpec", DavMailCookieSpec.class);
        AuthPolicy.registerAuthScheme((String)"Basic", LenientBasicScheme.class);
    }
}

