/*
 * Decompiled with CFR 0.152.
 */
package davmail.http;

import davmail.BundleMessage;
import davmail.Settings;
import davmail.http.DavGatewayX509TrustManager;
import davmail.http.DavMailX509KeyManager;
import davmail.http.SunPKCS11ProviderHandler;
import davmail.ui.PasswordPromptDialog;
import davmail.ui.tray.DavGatewayTray;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.KeyStoreBuilderParameters;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;

public class DavGatewaySSLProtocolSocketFactory
implements SecureProtocolSocketFactory {
    private SSLContext sslcontext;

    public static void register() {
        String urlString = Settings.getProperty("davmail.url");
        try {
            URL url = new URL(urlString);
            String protocol = url.getProtocol();
            if ("https".equals(protocol)) {
                int port = url.getPort();
                if (port < 0) {
                    port = 443;
                }
                Protocol.registerProtocol((String)url.getProtocol(), (Protocol)new Protocol(protocol, (ProtocolSocketFactory)new DavGatewaySSLProtocolSocketFactory(), port));
            }
        }
        catch (MalformedURLException e) {
            DavGatewayTray.error(new BundleMessage("LOG_INVALID_URL", urlString));
        }
    }

    private KeyStore.ProtectionParameter getProtectionParameter(String password) {
        if (password != null && password.length() > 0) {
            return new KeyStore.PasswordProtection(password.toCharArray());
        }
        return new KeyStore.CallbackHandlerProtection(new CallbackHandler(){

            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                if (callbacks.length > 0 && callbacks[0] instanceof PasswordCallback) {
                    PasswordPromptDialog passwordPromptDialog = new PasswordPromptDialog(((PasswordCallback)callbacks[0]).getPrompt());
                    ((PasswordCallback)callbacks[0]).setPassword(passwordPromptDialog.getPassword());
                }
            }
        });
    }

    private SSLContext createSSLContext() throws NoSuchAlgorithmException, InvalidAlgorithmParameterException, KeyManagementException, KeyStoreException {
        String algorithm;
        String pkcs11Library = Settings.getProperty("davmail.ssl.pkcs11Library");
        String clientKeystoreType = Settings.getProperty("davmail.ssl.clientKeystoreType");
        if (clientKeystoreType == null || clientKeystoreType.length() == 0) {
            clientKeystoreType = "PKCS11";
        }
        if (pkcs11Library != null && pkcs11Library.length() > 0 && "PKCS11".equals(clientKeystoreType)) {
            StringBuilder pkcs11Buffer = new StringBuilder();
            pkcs11Buffer.append("name=DavMail\n");
            pkcs11Buffer.append("library=").append(pkcs11Library).append('\n');
            String pkcs11Config = Settings.getProperty("davmail.ssl.pkcs11Config");
            if (pkcs11Config != null && pkcs11Config.length() > 0) {
                pkcs11Buffer.append(pkcs11Config).append('\n');
            }
            SunPKCS11ProviderHandler.registerProvider(pkcs11Buffer.toString());
        }
        if ("SunX509".equals(algorithm = KeyManagerFactory.getDefaultAlgorithm())) {
            algorithm = "NewSunX509";
        } else if ("IbmX509".equals(algorithm)) {
            algorithm = "NewIbmX509";
        }
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(algorithm);
        ArrayList<KeyStore.Builder> keyStoreBuilders = new ArrayList<KeyStore.Builder>();
        KeyStore.Builder scBuilder = KeyStore.Builder.newInstance("PKCS11", null, this.getProtectionParameter(null));
        keyStoreBuilders.add(scBuilder);
        String clientKeystoreFile = Settings.getProperty("davmail.ssl.clientKeystoreFile");
        String clientKeystorePass = Settings.getProperty("davmail.ssl.clientKeystorePass");
        if (clientKeystoreFile != null && clientKeystoreFile.length() > 0 && ("PKCS12".equals(clientKeystoreType) || "JKS".equals(clientKeystoreType))) {
            KeyStore.Builder fsBuilder = KeyStore.Builder.newInstance(clientKeystoreType, null, new File(clientKeystoreFile), this.getProtectionParameter(clientKeystorePass));
            keyStoreBuilders.add(fsBuilder);
        }
        KeyStoreBuilderParameters keyStoreBuilderParameters = new KeyStoreBuilderParameters(keyStoreBuilders);
        keyManagerFactory.init(keyStoreBuilderParameters);
        KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
        for (int i = 0; i < keyManagers.length; ++i) {
            KeyManager keyManager = keyManagers[i];
            if (!(keyManager instanceof X509KeyManager)) continue;
            keyManagers[i] = new DavMailX509KeyManager((X509KeyManager)keyManager);
        }
        SSLContext context = SSLContext.getInstance("SSL");
        context.init(keyManagers, new TrustManager[]{new DavGatewayX509TrustManager()}, null);
        return context;
    }

    private SSLContext getSSLContext() throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, InvalidAlgorithmParameterException {
        if (this.sslcontext == null) {
            this.sslcontext = this.createSSLContext();
        }
        return this.sslcontext;
    }

    public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException {
        try {
            return this.getSSLContext().getSocketFactory().createSocket(host, port, clientHost, clientPort);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e + " " + e.getMessage());
        }
        catch (KeyManagementException e) {
            throw new IOException(e + " " + e.getMessage());
        }
        catch (KeyStoreException e) {
            throw new IOException(e + " " + e.getMessage());
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new IOException(e + " " + e.getMessage());
        }
    }

    public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort, HttpConnectionParams params) throws IOException {
        try {
            return this.getSSLContext().getSocketFactory().createSocket(host, port, clientHost, clientPort);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e + " " + e.getMessage());
        }
        catch (KeyManagementException e) {
            throw new IOException(e + " " + e.getMessage());
        }
        catch (KeyStoreException e) {
            throw new IOException(e + " " + e.getMessage());
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new IOException(e + " " + e.getMessage());
        }
    }

    public Socket createSocket(String host, int port) throws IOException {
        try {
            return this.getSSLContext().getSocketFactory().createSocket(host, port);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e + " " + e.getMessage());
        }
        catch (KeyManagementException e) {
            throw new IOException(e + " " + e.getMessage());
        }
        catch (KeyStoreException e) {
            throw new IOException(e + " " + e.getMessage());
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new IOException(e + " " + e.getMessage());
        }
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
        try {
            return this.getSSLContext().getSocketFactory().createSocket(socket, host, port, autoClose);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e + " " + e.getMessage());
        }
        catch (KeyManagementException e) {
            throw new IOException(e + " " + e.getMessage());
        }
        catch (KeyStoreException e) {
            throw new IOException(e + " " + e.getMessage());
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new IOException(e + " " + e.getMessage());
        }
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass().equals(this.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

