/*
 * Decompiled with CFR 0.152.
 */
package davmail.http;

import davmail.ui.SelectCertificateDialog;
import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import javax.net.ssl.X509KeyManager;
import org.apache.log4j.Logger;

public class DavMailX509KeyManager
implements X509KeyManager {
    protected static final Logger LOGGER = Logger.getLogger(DavMailX509KeyManager.class);
    private final X509KeyManager keyManager;
    private String cachedAlias;

    public DavMailX509KeyManager(X509KeyManager keyManager) {
        this.keyManager = keyManager;
    }

    public String[] getClientAliases(String string, Principal[] principals) {
        return this.keyManager.getClientAliases(string, principals);
    }

    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        ArrayList<String> aliases = new ArrayList<String>();
        for (String keyTypeValue : keyType) {
            String[] keyAliases = this.keyManager.getClientAliases(keyTypeValue, null);
            if (keyAliases == null) continue;
            aliases.addAll(Arrays.asList(keyAliases));
        }
        if (aliases.size() > 1) {
            if (this.cachedAlias != null) {
                for (String alias : aliases) {
                    if (!this.cachedAlias.equals(this.stripAlias(alias))) continue;
                    LOGGER.debug((Object)(alias + " matched cached alias: " + this.cachedAlias));
                    return alias;
                }
                this.cachedAlias = null;
            }
            String[] aliasesArray = aliases.toArray(new String[aliases.size()]);
            SelectCertificateDialog selectCertificateDialog = new SelectCertificateDialog(aliasesArray);
            LOGGER.debug((Object)("User selected Key Alias: " + selectCertificateDialog.getSelectedAlias()));
            this.cachedAlias = this.stripAlias(selectCertificateDialog.getSelectedAlias());
            LOGGER.debug((Object)("Stored Key Alias Pattern: " + this.cachedAlias));
            return selectCertificateDialog.getSelectedAlias();
        }
        if (aliases.size() == 1) {
            LOGGER.debug((Object)"One Private Key found, returning that");
            return (String)aliases.get(0);
        }
        LOGGER.debug((Object)"No Private Keys found");
        return null;
    }

    protected String stripAlias(String alias) {
        String value = alias;
        if (value != null && value.length() > 1) {
            char firstChar = value.charAt(0);
            int dotIndex = value.indexOf(46);
            if (firstChar >= '0' && firstChar <= '9' && dotIndex >= 0) {
                value = value.substring(dotIndex + 1);
            }
        }
        return value;
    }

    public String[] getServerAliases(String string, Principal[] prncpls) {
        return this.keyManager.getServerAliases(string, prncpls);
    }

    public String chooseServerAlias(String string, Principal[] prncpls, Socket socket) {
        return this.keyManager.chooseServerAlias(string, prncpls, socket);
    }

    public X509Certificate[] getCertificateChain(String string) {
        return this.keyManager.getCertificateChain(string);
    }

    public PrivateKey getPrivateKey(String string) {
        return this.keyManager.getPrivateKey(string);
    }
}

