/*
 * Decompiled with CFR 0.152.
 */
package davmail.ui;

import davmail.BundleMessage;
import davmail.DavGateway;
import davmail.ui.browser.DesktopBrowser;
import davmail.ui.tray.DavGatewayTray;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class AboutFrame
extends JFrame {
    private final JEditorPane jEditorPane;

    public AboutFrame() {
        this.setDefaultCloseOperation(1);
        this.setTitle(BundleMessage.format("UI_ABOUT_DAVMAIL", new Object[0]));
        try {
            this.setIconImage(DavGatewayTray.getFrameIcon());
        }
        catch (NoSuchMethodError error) {
            DavGatewayTray.debug(new BundleMessage("LOG_UNABLE_TO_SET_ICON_IMAGE", new Object[0]));
        }
        try {
            JLabel imageLabel = new JLabel();
            ClassLoader classloader = this.getClass().getClassLoader();
            URL imageUrl = classloader.getResource("tray32.png");
            BufferedImage iconImage = ImageIO.read(imageUrl);
            if (iconImage != null) {
                ImageIcon icon = new ImageIcon(iconImage);
                imageLabel.setIcon(icon);
            }
            JPanel imagePanel = new JPanel();
            imagePanel.add(imageLabel);
            this.add("West", imagePanel);
        }
        catch (IOException e) {
            DavGatewayTray.error(new BundleMessage("LOG_UNABLE_TO_CREATE_ICON", new Object[0]), e);
        }
        this.jEditorPane = new JEditorPane();
        HTMLEditorKit htmlEditorKit = new HTMLEditorKit();
        StyleSheet stylesheet = htmlEditorKit.getStyleSheet();
        Font font = this.jEditorPane.getFont();
        stylesheet.addRule("body { font-size:small;font-family: " + (font == null ? "Arial" : font.getFamily()) + '}');
        this.jEditorPane.setEditorKit(htmlEditorKit);
        this.jEditorPane.setContentType("text/html");
        this.jEditorPane.setText(this.getContent(null));
        this.jEditorPane.setEditable(false);
        this.jEditorPane.setOpaque(false);
        this.jEditorPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hle) {
                if (HyperlinkEvent.EventType.ACTIVATED.equals(hle.getEventType())) {
                    try {
                        DesktopBrowser.browse(hle.getURL().toURI());
                    }
                    catch (URISyntaxException e) {
                        DavGatewayTray.error(new BundleMessage("LOG_UNABLE_TO_OPEN_LINK", new Object[0]), e);
                    }
                    AboutFrame.this.setVisible(false);
                }
            }
        });
        JPanel mainPanel = new JPanel();
        mainPanel.add(this.jEditorPane);
        this.add("Center", mainPanel);
        JPanel buttonPanel = new JPanel();
        JButton ok = new JButton(BundleMessage.format("UI_BUTTON_OK", new Object[0]));
        ActionListener close = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AboutFrame.this.setVisible(false);
            }
        };
        ok.addActionListener(close);
        buttonPanel.add(ok);
        this.add("South", buttonPanel);
        this.pack();
        this.setResizable(false);
        this.setLocation(this.getToolkit().getScreenSize().width / 2 - this.getSize().width / 2, this.getToolkit().getScreenSize().height / 2 - this.getSize().height / 2);
    }

    String getContent(String releasedVersion) {
        Package davmailPackage = DavGateway.class.getPackage();
        StringBuilder buffer = new StringBuilder();
        buffer.append(BundleMessage.format("UI_ABOUT_DAVMAIL_AUTHOR", new Object[0]));
        String currentVersion = davmailPackage.getImplementationVersion();
        if (currentVersion != null) {
            buffer.append(BundleMessage.format("UI_CURRENT_VERSION", currentVersion));
        }
        if (currentVersion != null && releasedVersion != null && currentVersion.compareTo(releasedVersion) != 0 || currentVersion == null && releasedVersion != null) {
            buffer.append(BundleMessage.format("UI_LATEST_VERSION", releasedVersion));
        }
        buffer.append(BundleMessage.format("UI_HELP_INSTRUCTIONS", new Object[0]));
        return buffer.toString();
    }

    public void update() {
        this.jEditorPane.setText(this.getContent(DavGateway.getReleasedVersion()));
        this.pack();
    }
}

