/*
 * Decompiled with CFR 0.152.
 */
package davmail.ui;

import davmail.BundleMessage;
import davmail.http.DavGatewayX509TrustManager;
import davmail.ui.tray.DavGatewayTray;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class AcceptCertificateDialog
extends JDialog {
    protected boolean accepted;

    public boolean isAccepted() {
        return this.accepted;
    }

    protected void addFieldValue(JPanel panel, String label, String value) {
        JPanel fieldPanel = new JPanel(new FlowLayout(0));
        fieldPanel.add(new JLabel("<html><b>" + label + ":</b></html>"));
        fieldPanel.add(new JLabel(value));
        panel.add(fieldPanel);
    }

    public AcceptCertificateDialog(X509Certificate certificate) {
        this.setAlwaysOnTop(true);
        String sha1Hash = DavGatewayX509TrustManager.getFormattedHash(certificate);
        DateFormat formatter = DateFormat.getDateInstance(2);
        this.setTitle(BundleMessage.format("UI_ACCEPT_CERTIFICATE", new Object[0]));
        try {
            this.setIconImage(DavGatewayTray.getFrameIcon());
        }
        catch (NoSuchMethodError error) {
            DavGatewayTray.debug(new BundleMessage("LOG_UNABLE_TO_SET_ICON_IMAGE", new Object[0]));
        }
        JPanel subjectPanel = new JPanel();
        subjectPanel.setLayout(new BoxLayout(subjectPanel, 1));
        subjectPanel.setBorder(BorderFactory.createTitledBorder(BundleMessage.format("UI_SERVER_CERTIFICATE", new Object[0])));
        this.addFieldValue(subjectPanel, BundleMessage.format("UI_ISSUED_TO", new Object[0]), DavGatewayX509TrustManager.getRDN(certificate.getSubjectDN()));
        this.addFieldValue(subjectPanel, BundleMessage.format("UI_ISSUED_BY", new Object[0]), DavGatewayX509TrustManager.getRDN(certificate.getIssuerDN()));
        Date now = new Date();
        String notBefore = formatter.format(certificate.getNotBefore());
        if (now.before(certificate.getNotBefore())) {
            notBefore = "<html><font color=\"#FF0000\">" + notBefore + "</font></html>";
        }
        this.addFieldValue(subjectPanel, BundleMessage.format("UI_VALID_FROM", new Object[0]), notBefore);
        String notAfter = formatter.format(certificate.getNotAfter());
        if (now.after(certificate.getNotAfter())) {
            notAfter = "<html><font color=\"#FF0000\">" + notAfter + "</font></html>";
        }
        this.addFieldValue(subjectPanel, BundleMessage.format("UI_VALID_UNTIL", new Object[0]), notAfter);
        this.addFieldValue(subjectPanel, BundleMessage.format("UI_SERIAL", new Object[0]), DavGatewayX509TrustManager.getFormattedSerial(certificate));
        this.addFieldValue(subjectPanel, BundleMessage.format("UI_FINGERPRINT", new Object[0]), sha1Hash);
        JPanel warningPanel = new JPanel(new FlowLayout(0));
        JLabel imageLabel = new JLabel();
        imageLabel.setIcon(UIManager.getIcon("OptionPane.warningIcon"));
        imageLabel.setText(BundleMessage.format("UI_UNTRUSTED_CERTIFICATE_HTML", new Object[0]));
        warningPanel.add(imageLabel);
        this.add((Component)warningPanel, "North");
        this.add((Component)subjectPanel, "Center");
        this.add((Component)this.getButtonPanel(), "South");
        this.setModal(true);
        this.pack();
        this.setLocation(this.getToolkit().getScreenSize().width / 2 - this.getSize().width / 2, this.getToolkit().getScreenSize().height / 2 - this.getSize().height / 2);
        this.setAlwaysOnTop(true);
        this.setVisible(true);
    }

    protected JPanel getButtonPanel() {
        JPanel buttonPanel = new JPanel();
        JButton accept = new JButton(BundleMessage.format("UI_BUTTON_ACCEPT", new Object[0]));
        JButton deny = new JButton(BundleMessage.format("UI_BUTTON_DENY", new Object[0]));
        accept.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AcceptCertificateDialog.this.accepted = true;
                AcceptCertificateDialog.this.setVisible(false);
            }
        });
        deny.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AcceptCertificateDialog.this.accepted = false;
                AcceptCertificateDialog.this.setVisible(false);
            }
        });
        buttonPanel.add(accept);
        buttonPanel.add(deny);
        return buttonPanel;
    }

    public static boolean isCertificateTrusted(final X509Certificate certificate) {
        final boolean[] answer = new boolean[1];
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    AcceptCertificateDialog certificateDialog = new AcceptCertificateDialog(certificate);
                    answer[0] = certificateDialog.isAccepted();
                }
            });
        }
        catch (InterruptedException ie) {
            DavGatewayTray.error(new BundleMessage("UI_ERROR_WAITING_FOR_CERTIFICATE_CHECK", new Object[0]), ie);
        }
        catch (InvocationTargetException ite) {
            DavGatewayTray.error(new BundleMessage("UI_ERROR_WAITING_FOR_CERTIFICATE_CHECK", new Object[0]), ite);
        }
        return answer[0];
    }
}

