/*
 * Decompiled with CFR 0.152.
 */
package davmail.ui;

import davmail.BundleMessage;
import davmail.ui.tray.DavGatewayTray;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class CredentialPromptDialog
extends JDialog {
    final JTextField principalField = new JTextField(15);
    final JPasswordField passwordField = new JPasswordField(15);
    protected String principal;
    protected char[] password;

    public char[] getPassword() {
        if (this.password != null) {
            return (char[])this.password.clone();
        }
        return "".toCharArray();
    }

    public String getPrincipal() {
        return this.principal;
    }

    public CredentialPromptDialog(String prompt) {
        this.setAlwaysOnTop(true);
        this.setTitle(BundleMessage.format("UI_KERBEROS_CREDENTIAL_PROMPT", new Object[0]));
        try {
            this.setIconImage(DavGatewayTray.getFrameIcon());
        }
        catch (NoSuchMethodError error) {
            DavGatewayTray.debug(new BundleMessage("LOG_UNABLE_TO_SET_ICON_IMAGE", new Object[0]));
        }
        JPanel questionPanel = new JPanel();
        questionPanel.setLayout(new BoxLayout(questionPanel, 1));
        JLabel imageLabel = new JLabel();
        imageLabel.setIcon(UIManager.getIcon("OptionPane.questionIcon"));
        questionPanel.add(imageLabel);
        this.passwordField.setMaximumSize(this.passwordField.getPreferredSize());
        this.passwordField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CredentialPromptDialog.this.principal = CredentialPromptDialog.this.principalField.getText();
                CredentialPromptDialog.this.password = CredentialPromptDialog.this.passwordField.getPassword();
                CredentialPromptDialog.this.setVisible(false);
            }
        });
        JPanel credentialPanel = new JPanel(new GridLayout(2, 2));
        JLabel promptLabel = new JLabel(' ' + prompt.trim());
        promptLabel.setHorizontalAlignment(4);
        promptLabel.setVerticalAlignment(0);
        credentialPanel.add(promptLabel);
        this.principalField.setMaximumSize(this.principalField.getPreferredSize());
        credentialPanel.add(this.principalField);
        JLabel passwordLabel = new JLabel(BundleMessage.format("UI_KERBEROS_PASSWORD_PROMPT", new Object[0]));
        passwordLabel.setHorizontalAlignment(4);
        passwordLabel.setVerticalAlignment(0);
        credentialPanel.add(passwordLabel);
        this.passwordField.setMaximumSize(this.passwordField.getPreferredSize());
        credentialPanel.add(this.passwordField);
        this.add((Component)questionPanel, "West");
        this.add((Component)credentialPanel, "Center");
        this.add((Component)this.getButtonPanel(), "South");
        this.setModal(true);
        this.pack();
        this.setLocation(this.getToolkit().getScreenSize().width / 2 - this.getSize().width / 2, this.getToolkit().getScreenSize().height / 2 - this.getSize().height / 2);
        this.setAlwaysOnTop(true);
        this.setVisible(true);
    }

    protected JPanel getButtonPanel() {
        JPanel buttonPanel = new JPanel();
        JButton okButton = new JButton(BundleMessage.format("UI_BUTTON_OK", new Object[0]));
        JButton cancelButton = new JButton(BundleMessage.format("UI_BUTTON_CANCEL", new Object[0]));
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CredentialPromptDialog.this.principal = CredentialPromptDialog.this.principalField.getText();
                CredentialPromptDialog.this.password = CredentialPromptDialog.this.passwordField.getPassword();
                CredentialPromptDialog.this.setVisible(false);
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CredentialPromptDialog.this.principal = null;
                CredentialPromptDialog.this.password = null;
                CredentialPromptDialog.this.setVisible(false);
            }
        });
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        return buttonPanel;
    }
}

