/*
 * Decompiled with CFR 0.152.
 */
package davmail.ui;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class OSXAdapter
implements InvocationHandler {
    protected final Object targetObject;
    protected final Method targetMethod;
    protected final String proxySignature;
    static Object macOSXApplication;

    public static void setQuitHandler(Object target, Method quitHandler) throws InvocationTargetException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        OSXAdapter.setHandler(new OSXAdapter("handleQuit", target, quitHandler));
    }

    public static void setAboutHandler(Object target, Method aboutHandler) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException, ClassNotFoundException, InstantiationException {
        boolean enableAboutMenu;
        boolean bl = enableAboutMenu = target != null && aboutHandler != null;
        if (enableAboutMenu) {
            OSXAdapter.setHandler(new OSXAdapter("handleAbout", target, aboutHandler));
        }
        Method enableAboutMethod = macOSXApplication.getClass().getDeclaredMethod("setEnabledAboutMenu", Boolean.TYPE);
        enableAboutMethod.invoke(macOSXApplication, enableAboutMenu);
    }

    public static void setPreferencesHandler(Object target, Method prefsHandler) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException, ClassNotFoundException, InstantiationException {
        boolean enablePrefsMenu;
        boolean bl = enablePrefsMenu = target != null && prefsHandler != null;
        if (enablePrefsMenu) {
            OSXAdapter.setHandler(new OSXAdapter("handlePreferences", target, prefsHandler));
        }
        Method enablePrefsMethod = macOSXApplication.getClass().getDeclaredMethod("setEnabledPreferencesMenu", Boolean.TYPE);
        enablePrefsMethod.invoke(macOSXApplication, enablePrefsMenu);
    }

    public static void setFileHandler(Object target, Method fileHandler) throws InvocationTargetException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        OSXAdapter.setHandler(new OSXAdapter("handleOpenFile", target, fileHandler){

            public boolean callTarget(Object appleEvent) {
                if (appleEvent != null) {
                    try {
                        Method getFilenameMethod = appleEvent.getClass().getDeclaredMethod("getFilename", null);
                        String filename = (String)getFilenameMethod.invoke(appleEvent, (Object[])null);
                        this.targetMethod.invoke(this.targetObject, filename);
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                }
                return true;
            }
        });
    }

    public static void setHandler(OSXAdapter adapter) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException {
        Class<?> applicationClass = Class.forName("com.apple.eawt.Application");
        if (macOSXApplication == null) {
            macOSXApplication = applicationClass.getConstructor(null).newInstance(null);
        }
        Class<?> applicationListenerClass = Class.forName("com.apple.eawt.ApplicationListener");
        Method addListenerMethod = applicationClass.getDeclaredMethod("addApplicationListener", applicationListenerClass);
        Object osxAdapterProxy = Proxy.newProxyInstance(OSXAdapter.class.getClassLoader(), new Class[]{applicationListenerClass}, (InvocationHandler)adapter);
        addListenerMethod.invoke(macOSXApplication, osxAdapterProxy);
    }

    protected OSXAdapter(String proxySignature, Object target, Method handler) {
        this.proxySignature = proxySignature;
        this.targetObject = target;
        this.targetMethod = handler;
    }

    public boolean callTarget(Object appleEvent) throws InvocationTargetException, IllegalAccessException {
        Object result = this.targetMethod.invoke(this.targetObject, (Object[])null);
        return result == null || Boolean.valueOf(result.toString()) != false;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.isCorrectMethod(method, args)) {
            boolean handled = this.callTarget(args[0]);
            this.setApplicationEventHandled(args[0], handled);
        }
        return null;
    }

    protected boolean isCorrectMethod(Method method, Object[] args) {
        return this.targetMethod != null && this.proxySignature.equals(method.getName()) && args.length == 1;
    }

    protected void setApplicationEventHandled(Object event, boolean handled) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        if (event != null) {
            Method setHandledMethod = event.getClass().getDeclaredMethod("setHandled", Boolean.TYPE);
            setHandledMethod.invoke(event, handled);
        }
    }
}

