/*
 * Decompiled with CFR 0.152.
 */
package davmail.ui;

import davmail.util.IOUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

public class OSXInfoPlist {
    protected static final Logger LOGGER = Logger.getLogger(OSXInfoPlist.class);
    protected static final String INFO_PLIST_PATH = "Contents/Info.plist";

    private OSXInfoPlist() {
    }

    protected static boolean isOSX() {
        return System.getProperty("os.name").toLowerCase().startsWith("mac os x");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getInfoPlistContent() throws IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(OSXInfoPlist.getInfoPlistPath());
            String string = new String(IOUtil.readFully(fileInputStream), "UTF-8");
            return string;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static boolean isHideFromDock() {
        boolean result = false;
        try {
            result = OSXInfoPlist.isOSX() && OSXInfoPlist.getInfoPlistContent().contains("<key>LSUIElement</key><string>1</string>");
        }
        catch (IOException e) {
            LOGGER.warn((Object)"Unable to update Info.plist", (Throwable)e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setOSXHideFromDock(boolean hideFromDock) {
        block5: {
            try {
                boolean currentHideFromDock;
                if (!OSXInfoPlist.isOSX() || (currentHideFromDock = OSXInfoPlist.isHideFromDock()) == hideFromDock) break block5;
                String content = OSXInfoPlist.getInfoPlistContent();
                FileOutputStream fileOutputStream = new FileOutputStream(OSXInfoPlist.getInfoPlistPath());
                try {
                    fileOutputStream.write(content.replaceFirst("<key>LSUIElement</key><string>" + (currentHideFromDock ? "1" : "0") + "</string>", "<key>LSUIElement</key><string>" + (hideFromDock ? "1" : "0") + "</string>").getBytes("UTF-8"));
                }
                finally {
                    fileOutputStream.close();
                }
                fileOutputStream.close();
            }
            catch (IOException e) {
                LOGGER.warn((Object)"Unable to update Info.plist", (Throwable)e);
            }
        }
    }

    private static String getInfoPlistPath() throws IOException {
        File file = new File(INFO_PLIST_PATH);
        if (file.exists()) {
            return INFO_PLIST_PATH;
        }
        String libraryPath = System.getProperty("java.library.path");
        if (libraryPath != null && libraryPath.endsWith("Contents/MacOS") && (file = new File(libraryPath.replace("Contents/MacOS", INFO_PLIST_PATH))).exists()) {
            return INFO_PLIST_PATH;
        }
        throw new IOException("Info.plist file not found");
    }
}

