/*
 * Decompiled with CFR 0.152.
 */
package davmail.ui;

import davmail.BundleMessage;
import davmail.ui.tray.DavGatewayTray;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class SelectCertificateDialog
extends JDialog {
    protected final JList aliasListBox;
    protected String selectedAlias;

    public String getSelectedAlias() {
        return this.selectedAlias;
    }

    public SelectCertificateDialog(String[] aliases) {
        this.setAlwaysOnTop(true);
        this.setTitle(BundleMessage.format("UI_CERTIFICATE_ALIAS_PROMPT", new Object[0]));
        try {
            this.setIconImage(DavGatewayTray.getFrameIcon());
        }
        catch (NoSuchMethodError error) {
            DavGatewayTray.debug(new BundleMessage("LOG_UNABLE_TO_SET_ICON_IMAGE", new Object[0]));
        }
        JPanel questionPanel = new JPanel();
        questionPanel.setLayout(new BoxLayout(questionPanel, 1));
        JLabel imageLabel = new JLabel();
        imageLabel.setIcon(UIManager.getIcon("OptionPane.questionIcon"));
        imageLabel.setText(BundleMessage.format("UI_CERTIFICATE_ALIAS_PROMPT", new Object[0]));
        questionPanel.add(imageLabel);
        this.aliasListBox = new JList<String>(aliases);
        this.aliasListBox.setMaximumSize(this.aliasListBox.getPreferredSize());
        JPanel aliasPanel = new JPanel();
        aliasPanel.setLayout(new BoxLayout(aliasPanel, 1));
        aliasPanel.add(this.aliasListBox);
        this.add((Component)questionPanel, "North");
        this.add((Component)aliasPanel, "Center");
        this.add((Component)this.getButtonPanel(), "South");
        this.setModal(true);
        this.pack();
        this.setLocation(this.getToolkit().getScreenSize().width / 2 - this.getSize().width / 2, this.getToolkit().getScreenSize().height / 2 - this.getSize().height / 2);
        this.setAlwaysOnTop(true);
        this.setVisible(true);
    }

    protected JPanel getButtonPanel() {
        JPanel buttonPanel = new JPanel();
        JButton okButton = new JButton(BundleMessage.format("UI_BUTTON_OK", new Object[0]));
        JButton cancelButton = new JButton(BundleMessage.format("UI_BUTTON_CANCEL", new Object[0]));
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectCertificateDialog.this.selectedAlias = (String)SelectCertificateDialog.this.aliasListBox.getSelectedValue();
                SelectCertificateDialog.this.setVisible(false);
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectCertificateDialog.this.selectedAlias = null;
                SelectCertificateDialog.this.setVisible(false);
            }
        });
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        return buttonPanel;
    }
}

