/*
 * Decompiled with CFR 0.152.
 */
package davmail.ui.tray;

import davmail.BundleMessage;
import davmail.DavGateway;
import davmail.Settings;
import davmail.ui.AboutFrame;
import davmail.ui.SettingsFrame;
import davmail.ui.tray.DavGatewayTray;
import davmail.ui.tray.DavGatewayTrayInterface;
import java.awt.AWTException;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.lf5.LF5Appender;
import org.apache.log4j.lf5.LogLevel;
import org.apache.log4j.lf5.viewer.LogBrokerMonitor;

public class AwtGatewayTray
implements DavGatewayTrayInterface {
    protected static final String TRAY_ACTIVE_PNG = "tray2.png";
    protected static final String TRAY_PNG = "tray.png";
    protected static final String TRAY_INACTIVE_PNG = "trayinactive.png";
    static AboutFrame aboutFrame;
    static SettingsFrame settingsFrame;
    ActionListener settingsListener;
    static TrayIcon trayIcon;
    private static Image image;
    private static Image image2;
    private static Image inactiveImage;
    static LogBrokerMonitor logBrokerMonitor;
    private boolean isActive = true;

    protected AwtGatewayTray() {
    }

    public Image getFrameIcon() {
        return image;
    }

    public void switchIcon() {
        this.isActive = true;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (trayIcon.getImage().equals(image)) {
                    trayIcon.setImage(image2);
                } else {
                    trayIcon.setImage(image);
                }
            }
        });
    }

    public void resetIcon() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                trayIcon.setImage(image);
            }
        });
    }

    public void inactiveIcon() {
        this.isActive = false;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                trayIcon.setImage(inactiveImage);
            }
        });
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void displayMessage(final String message, final Level level) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (trayIcon != null) {
                    TrayIcon.MessageType messageType = null;
                    if (level.equals((Object)Level.INFO)) {
                        messageType = TrayIcon.MessageType.INFO;
                    } else if (level.equals((Object)Level.WARN)) {
                        messageType = TrayIcon.MessageType.WARNING;
                    } else if (level.equals((Object)Level.ERROR)) {
                        messageType = TrayIcon.MessageType.ERROR;
                    }
                    if (messageType != null) {
                        trayIcon.displayMessage(BundleMessage.format("UI_DAVMAIL_GATEWAY", new Object[0]), message, messageType);
                    }
                    trayIcon.setToolTip(BundleMessage.format("UI_DAVMAIL_GATEWAY", new Object[0]) + '\n' + message);
                }
            }
        });
    }

    public void about() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                aboutFrame.update();
                aboutFrame.setVisible(true);
                aboutFrame.toFront();
                aboutFrame.requestFocus();
            }
        });
    }

    public void preferences() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                settingsFrame.reload();
                settingsFrame.setVisible(true);
                settingsFrame.toFront();
                settingsFrame.repaint();
                settingsFrame.requestFocus();
            }
        });
    }

    public void init() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AwtGatewayTray.this.createAndShowGUI();
            }
        });
    }

    public void dispose() {
        SystemTray.getSystemTray().remove(trayIcon);
        settingsFrame.dispose();
        aboutFrame.dispose();
        if (logBrokerMonitor != null) {
            logBrokerMonitor.dispose();
        }
    }

    protected void createAndShowGUI() {
        System.setProperty("swing.defaultlaf", UIManager.getSystemLookAndFeelClassName());
        SystemTray tray = SystemTray.getSystemTray();
        image = DavGatewayTray.loadImage(this.getTrayIconPath());
        image2 = DavGatewayTray.loadImage(this.getTrayIconActivePath());
        inactiveImage = DavGatewayTray.loadImage(this.getTrayIconInactivePath());
        PopupMenu popup = new PopupMenu();
        aboutFrame = new AboutFrame();
        ActionListener aboutListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AwtGatewayTray.this.about();
            }
        };
        MenuItem aboutItem = new MenuItem(BundleMessage.format("UI_ABOUT", new Object[0]));
        aboutItem.addActionListener(aboutListener);
        popup.add(aboutItem);
        settingsFrame = new SettingsFrame();
        this.settingsListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AwtGatewayTray.this.preferences();
            }
        };
        MenuItem defaultItem = new MenuItem(BundleMessage.format("UI_SETTINGS", new Object[0]));
        defaultItem.addActionListener(this.settingsListener);
        popup.add(defaultItem);
        MenuItem logItem = new MenuItem(BundleMessage.format("UI_SHOW_LOGS", new Object[0]));
        logItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Logger rootLogger = Logger.getRootLogger();
                LF5Appender lf5Appender = (LF5Appender)rootLogger.getAppender("LF5Appender");
                if (lf5Appender == null) {
                    logBrokerMonitor = new LogBrokerMonitor(LogLevel.getLog4JLevels()){

                        protected void closeAfterConfirm() {
                            this.hide();
                        }
                    };
                    lf5Appender = new LF5Appender(logBrokerMonitor);
                    lf5Appender.setName("LF5Appender");
                    rootLogger.addAppender((Appender)lf5Appender);
                }
                lf5Appender.getLogBrokerMonitor().show();
            }
        });
        popup.add(logItem);
        ActionListener exitListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    DavGateway.stop();
                }
                catch (Exception exc) {
                    DavGatewayTray.error(exc);
                }
                System.exit(0);
            }
        };
        MenuItem exitItem = new MenuItem(BundleMessage.format("UI_EXIT", new Object[0]));
        exitItem.addActionListener(exitListener);
        popup.add(exitItem);
        trayIcon = new TrayIcon(image, BundleMessage.format("UI_DAVMAIL_GATEWAY", new Object[0]), popup);
        trayIcon.addActionListener(this.settingsListener);
        try {
            tray.add(trayIcon);
        }
        catch (AWTException e) {
            DavGatewayTray.warn(new BundleMessage("LOG_UNABLE_TO_CREATE_TRAY", new Object[0]), e);
        }
        if (Settings.isFirstStart()) {
            settingsFrame.setVisible(true);
            settingsFrame.toFront();
            settingsFrame.repaint();
            settingsFrame.requestFocus();
        }
    }

    protected String getTrayIconPath() {
        return TRAY_PNG;
    }

    protected String getTrayIconActivePath() {
        return TRAY_ACTIVE_PNG;
    }

    protected String getTrayIconInactivePath() {
        return TRAY_INACTIVE_PNG;
    }
}

