/*
 * Decompiled with CFR 0.152.
 */
package davmail.ui.tray;

import davmail.BundleMessage;
import davmail.Settings;
import davmail.exchange.NetworkDownException;
import davmail.ui.tray.AwtGatewayTray;
import davmail.ui.tray.DavGatewayTrayInterface;
import davmail.ui.tray.FrameGatewayTray;
import davmail.ui.tray.OSXAwtGatewayTray;
import davmail.ui.tray.OSXFrameGatewayTray;
import davmail.ui.tray.SwtGatewayTray;
import java.awt.Image;
import java.awt.SystemTray;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public final class DavGatewayTray {
    private static final Logger LOGGER = Logger.getLogger((String)"davmail");
    private static final long ICON_SWITCH_MINIMUM_DELAY = 250L;
    private static long lastIconSwitch;
    static DavGatewayTrayInterface davGatewayTray;

    private DavGatewayTray() {
    }

    public static Image getFrameIcon() {
        Image icon = null;
        if (davGatewayTray != null) {
            icon = davGatewayTray.getFrameIcon();
        }
        return icon;
    }

    public static void switchIcon() {
        if (davGatewayTray != null && System.currentTimeMillis() - lastIconSwitch > 250L) {
            davGatewayTray.switchIcon();
            lastIconSwitch = System.currentTimeMillis();
        }
    }

    public static void resetIcon() {
        if (davGatewayTray != null && DavGatewayTray.isActive()) {
            davGatewayTray.resetIcon();
        }
    }

    public static boolean isActive() {
        return davGatewayTray == null || davGatewayTray.isActive();
    }

    private static void displayMessage(BundleMessage message, Level level) {
        LOGGER.log((Priority)level, (Object)message.formatLog());
        if (davGatewayTray != null && !Settings.getBooleanProperty("davmail.disableGuiNotifications")) {
            davGatewayTray.displayMessage(message.format(), level);
        }
    }

    private static void displayMessage(BundleMessage message, Exception e, Level level) {
        if (e instanceof NetworkDownException) {
            LOGGER.log((Priority)level, (Object)BundleMessage.getExceptionLogMessage(message, e));
        } else {
            LOGGER.log((Priority)level, (Object)BundleMessage.getExceptionLogMessage(message, e), (Throwable)e);
        }
        if (davGatewayTray != null && !Settings.getBooleanProperty("davmail.disableGuiNotifications") && !(e instanceof NetworkDownException)) {
            davGatewayTray.displayMessage(BundleMessage.getExceptionMessage(message, e), level);
        }
        if (davGatewayTray != null && e instanceof NetworkDownException) {
            davGatewayTray.inactiveIcon();
        }
    }

    public static void debug(BundleMessage message) {
        DavGatewayTray.displayMessage(message, Level.DEBUG);
    }

    public static void info(BundleMessage message) {
        DavGatewayTray.displayMessage(message, Level.INFO);
    }

    public static void warn(BundleMessage message) {
        DavGatewayTray.displayMessage(message, Level.WARN);
    }

    public static void warn(Exception e) {
        DavGatewayTray.displayMessage(null, e, Level.WARN);
    }

    public static void error(BundleMessage message) {
        DavGatewayTray.displayMessage(message, Level.ERROR);
    }

    public static void log(Exception e) {
        if (e instanceof NetworkDownException) {
            DavGatewayTray.warn(e);
        } else {
            DavGatewayTray.error(e);
        }
    }

    public static void error(Exception e) {
        DavGatewayTray.displayMessage(null, e, Level.ERROR);
    }

    public static void debug(BundleMessage message, Exception e) {
        DavGatewayTray.displayMessage(message, e, Level.DEBUG);
    }

    public static void warn(BundleMessage message, Exception e) {
        DavGatewayTray.displayMessage(message, e, Level.WARN);
    }

    public static void error(BundleMessage message, Exception e) {
        DavGatewayTray.displayMessage(message, e, Level.ERROR);
    }

    public static void init() {
        String currentDesktop = System.getenv("XDG_CURRENT_DESKTOP");
        String javaVersion = System.getProperty("java.version");
        String arch = System.getProperty("sun.arch.data.model");
        LOGGER.debug((Object)("OS Name: " + System.getProperty("os.name") + " Java version: " + javaVersion + (arch != null ? ' ' + arch : "") + " System tray " + (SystemTray.isSupported() ? "" : "not ") + "supported " + (currentDesktop == null ? "" : "Current Desktop: " + currentDesktop)));
        if (!Settings.getBooleanProperty("davmail.server")) {
            if ("Unity".equals(currentDesktop)) {
                LOGGER.info((Object)"Detected Unity desktop, please follow instructions at http://davmail.sourceforge.net/linuxsetup.html to restore normal systray or run DavMail in server mode");
            }
            ClassLoader classloader = DavGatewayTray.class.getClassLoader();
            try {
                classloader.loadClass("org.eclipse.swt.SWT");
                davGatewayTray = new SwtGatewayTray();
                davGatewayTray.init();
            }
            catch (ClassNotFoundException e) {
                DavGatewayTray.info(new BundleMessage("LOG_SWT_NOT_AVAILABLE", new Object[0]));
            }
            if (davGatewayTray == null) {
                try {
                    if (SystemTray.isSupported()) {
                        davGatewayTray = DavGatewayTray.isOSX() ? new OSXAwtGatewayTray() : new AwtGatewayTray();
                        davGatewayTray.init();
                    }
                }
                catch (NoClassDefFoundError e) {
                    DavGatewayTray.info(new BundleMessage("LOG_SYSTEM_TRAY_NOT_AVAILABLE", new Object[0]));
                }
            }
            if (davGatewayTray == null) {
                davGatewayTray = DavGatewayTray.isOSX() ? new OSXFrameGatewayTray() : new FrameGatewayTray();
                davGatewayTray.init();
            }
        }
    }

    private static boolean isOSX() {
        return System.getProperty("os.name").toLowerCase().startsWith("mac os x");
    }

    public static Image loadImage(String fileName) {
        BufferedImage result = null;
        try {
            ClassLoader classloader = DavGatewayTray.class.getClassLoader();
            URL imageUrl = classloader.getResource(fileName);
            if (imageUrl == null) {
                throw new IOException("Missing resource: " + fileName);
            }
            result = ImageIO.read(imageUrl);
        }
        catch (IOException e) {
            DavGatewayTray.warn(new BundleMessage("LOG_UNABLE_TO_LOAD_IMAGE", new Object[0]), e);
        }
        return result;
    }

    public static void dispose() {
        if (davGatewayTray != null) {
            davGatewayTray.dispose();
        }
    }
}

